/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.AccordionLayout;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;
import com.gwtext.client.widgets.tree.event.TreeNodeListenerAdapter;
import org.jboss.bpm.console.client.metric.MetricOverviewEditor;
import org.jboss.bpm.console.client.process.ProcessDefinitionListEditor;

import java.util.ArrayList;
import java.util.List;

/**
 * The main menu on the left hand.
 * Keeps a list of {@link org.jboss.bpm.console.client.MenuSection}.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Menu extends Panel
{
   private final MainView view;
   private List<Panel> sections = new ArrayList<Panel>();

   public Menu(final MainView view)
   {
      super();
      this.view = view;

      final AccordionLayout accordion = new AccordionLayout(true);

      this.setTitle("");
      this.setCollapsible(true);
      this.setWidth(200);
      this.setLayout(accordion);

      MenuSection navPanel = new MenuSection("Process Management", "bpm-process-icon", new ProcessTree());
      MenuSection taskPanel = new MenuSection("Task Management", "bpm-task-icon", null);
      MenuSection metricPanel = new MenuSection("Metrics and Stats", "bpm-metric-icon", new MetricTree());
      MenuSection settingsPanel = new MenuSection("Settings", "bpm-settings-icon", new SettingsTree());

      this.addSection(navPanel);
      this.addSection(taskPanel);
      this.addSection(metricPanel);
      this.addSection(settingsPanel);
   }

   public void addSection(MenuSection menuSection)
   {
      this.sections.add(menuSection);
      this.add(menuSection);
   }

   class ProcessTree extends TreePanel
   {

      public ProcessTree() {

         TreeNode root = new TreeNode("Process Definitions");

         TreeNode definitions = new TreeNode("View definitions");
         definitions.setExpanded(true);
         definitions.addListener(
           new TreeNodeListenerAdapter()
           {
              public void onClick(Node node, EventObject eventObject)
              {
                 if(view.hasEditor(ProcessDefinitionListEditor.ID))
                 {
                    view.showEditor(ProcessDefinitionListEditor.ID);
                 }
                 else
                 {
                    view.addEditor( new ProcessDefinitionListEditor(view) );
                 }

              }
           }
         );
         TreeNode upload = new TreeNode("Upload new definitions");
         upload.setExpanded(true);

         root.appendChild(definitions);
         root.appendChild(upload);

         setRootVisible(true);
         setRootNode(root);
         root.setExpanded(true);
      }
   }

   class MetricTree extends TreePanel
   {

      public MetricTree() {

         TreeNode root = new TreeNode("Process Metrics");

         TreeNode overview = new TreeNode("Process workload");
         overview.setExpanded(true);
         overview.addListener(
           new TreeNodeListenerAdapter()
           {
              public void onClick(Node node, EventObject eventObject)
              {
                 if(view.hasEditor(MetricOverviewEditor.ID))
                 {
                    view.showEditor(MetricOverviewEditor.ID);
                 }
                 else
                 {
                    view.addEditor( new MetricOverviewEditor(view) );
                 }

              }
           }
         );

         TreeNode export = new TreeNode("Export stats");
         export.setExpanded(true);

         root.appendChild(overview);
         root.appendChild(export);

         setRootVisible(true);
         setRootNode(root);
         root.setExpanded(true);
      }
   }

   class SettingsTree extends TreePanel
   {

      public SettingsTree()
      {
         TreeNode root = new TreeNode("Debug");

         TreeNode overview = new TreeNode("Assigned roles");
         overview.setExpanded(true);
         overview.addListener(
           new TreeNodeListenerAdapter()
           {
              public void onClick(Node node, EventObject eventObject)
              {
                 StringBuffer sb = new StringBuffer();
                 for(String roleName : view.getRolesAssigned())
                 {
                     sb.append("<br> - ").append(roleName);
                 }

                 view.displayMessage("Assigned roles: " + sb.toString(), false);
              }
           }
         );

         root.appendChild(overview);
         
         setRootVisible(true);
         setRootNode(root);
         root.setExpanded(true);

      }
   }
}
