/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import org.jboss.bpm.console.client.model.ProcessInstance;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class URLBuilder
{
   private final String consoleServerUrl;
   private final String webContext;

   public URLBuilder(String consoleServerUrl, String webContext)
   {
      this.consoleServerUrl = consoleServerUrl;
      this.webContext = webContext;
   }

   public String getConsoleServerUrl()
   {
      return consoleServerUrl;
   }

   public String getWebContext()
   {
      return webContext;
   }

   private String getBaseUrl()
   {
      return consoleServerUrl + "/" + webContext;
   }

   public String getProcessDefinitionURL()
   {
      return getBaseUrl() + "/rs/process/definitions";
   }

   public String getProcessInstanceURL(long processId)
   {
      return getBaseUrl() + "/rs/process/definitions/"+processId+"/instances";
   }

   public String getUserInRoleURL(String[] possibleRoles)
   {
      StringBuffer sb = new StringBuffer();
      for(int i=0; i<possibleRoles.length; i++)
      {
         sb.append(possibleRoles[i]);
         if(i<possibleRoles.length-1)
            sb.append(",");
      }
      return getBaseUrl() + "/rs/user/roles?roleCheck="+sb.toString();
   }

   @Deprecated
   public String getRemoveDefinitionURL(long processId)
   {
      return getBaseUrl() + "/rs/process/definitions/" + processId + "/remove";
   }

   public String getProcessImageURL(long processId)
   {
      return getBaseUrl() + "/rs/jbpm3/definitions/" + processId + "/image";
   }

   public String getDiagramInfoURL(long processId)
   {
      return getBaseUrl() + "/rs/jbpm3/definitions/" + processId + "/diagramInfo";
   }

   public String getActiveNodeInfoURL(long instanceId)
   {
      return getBaseUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
   }

   public String getStateChangeURL(long instanceId, ProcessInstance.STATE state)
   {
      return getBaseUrl() + "/rs/process/instances/" + instanceId + "/state/"+state;
   }

   public String getStartNewInstanceURL(long processId)
   {
      return getBaseUrl() + "/rs/process/definitions/"+processId+"/instances/new";
   }

   public String getUploadDefinitionURL()
   {
      return getBaseUrl() + "/rs/jbpm3/definitions/new";
   }

   public String getTaskListByActorURL(List<String> actors)
   {
      StringBuffer sb = new StringBuffer();
      int i = 0;
      for(String s : actors)
      {
         sb.append(s);
         if(i<actors.size()-1)
            sb.append(",");
         i++;
      }
      return getBaseUrl() + "/rs/tasks/actor?actors="+sb.toString();
   }

   public String getTaskFormDefURL(long processId, long taskId)
   {
      return getBaseUrl() + "/rs/tasks/forms/"+processId+"/"+taskId;
   }
}
