/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.metric;

import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.widgets.TeaserPanel;
import org.jboss.bpm.console.client.widgets.HelpPanel;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.process.ProcessInstanceEditor;
import org.jboss.bpm.console.client.process.ProcessInstanceListEditor;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.core.EventObject;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class DefinitionMetricEditor extends Editor
{

   private ProcessDefinition parent;
   private MainView view;
   private Panel teaserPanel;

   public DefinitionMetricEditor(final MainView view, final ProcessDefinition proc)
   {
      super();
      this.view = view;
      this.parent = proc;

      this.setId(MetricOverviewEditor.ID+"."+proc.getName());

      // -----------------------------------------------

      this.setLayout( new ColumnLayout() );
      this.setWidth(UIConstants.EDITOR_WIDTH);

      // -----------------------------------------------

      teaserPanel = new TeaserPanel();

      HelpPanel instancePanel = new HelpPanel(UIConstants.TEASER_PANEL_WIDTH, 180, "Process instances");
      instancePanel.setIconCls("bpm-process-icon");            

      instancePanel.setContent(
        "You can manage running instances through the process management editor."
      );

      Toolbar bottomToolbar = new Toolbar();
      bottomToolbar.addFill();
      bottomToolbar.addButton(
        new ToolbarButton("View instances", new ButtonListenerAdapter() {
           public void onClick(Button button, EventObject e)
           {
              String editorId = ProcessInstanceEditor.ID+"."+proc.getName();

              if(view.hasEditor(editorId))
                 view.showEditor(editorId);
              else
                 view.addEditor( new ProcessInstanceListEditor(proc, view) );
           }
        })
      );

      instancePanel.setBottomToolbar(bottomToolbar);
      teaserPanel.add(instancePanel);

      // -----------------------------------------------

      this.add( new DefinitionMetricView(view, proc),  new ColumnLayoutData(0.7));
      this.add( teaserPanel, new ColumnLayoutData(0.3));
   }

   public String getEditorId()
   {
      return getId(); 
   }

   public String getTitle()
   {
      return parent.getName() + " metrics"; 
   }

   public String getIconCSS()
   {
      return "bpm-metric-icon"; 
   }
}
