/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.metric;

import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.core.Position;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstancePerformance;
import org.jboss.bpm.console.client.widgets.LineChart;

import java.util.Iterator;
import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class DefinitionMetricView extends Panel
{
   private ProcessDefinition parent;

   private MainView view;
      
   public DefinitionMetricView(MainView view, ProcessDefinition parent)
   {
      super();
      this.view = view;
      this.parent = parent;

      this.setHeader(false);
      this.setBorder(false);

      // ----------------------------------------

      ProcessInstancePerformance perf =
        DAOFactory.createMetricsDAO().getProcessInstancePerformance(parent.getProcessId());

      LineChart chart = new LineChart(
        parent.getName() + " performance", 380, 260, perf.getInstanceMetrics(), "Instance", "t"
      );

      double[] fixture = deriveFixture(perf);

      Panel chartPanel = new Panel();
      chartPanel.setPaddings(10);
      chartPanel.setHeader(false);
      chartPanel.setBorder(false);
      chartPanel.setWidth(UIConstants.EDITOR_WIDTH);
      chartPanel.add(chart);

      // ----------------------------------------

      Panel panel = new Panel();
      panel.setBorder(false);
      panel.setFrame(false);
      panel.setPaddings(10);

      //create the form
      FormPanel formPanel = new FormPanel();
      formPanel.setLabelAlign(Position.LEFT);
      formPanel.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
      formPanel.setHeader(false);
      formPanel.setFrame(false);
      formPanel.setPaddings(5, 5, 5, 0);
      formPanel.setLabelWidth(120);

      //create first collapsible fieldset with checkbox
      FieldSet fieldSet = new FieldSet();
      fieldSet.setCheckboxToggle(false);
      fieldSet.setTitle("Process metrics");
      fieldSet.setCollapsed(false);
      fieldSet.setAutoHeight(true);
      fieldSet.setBorder(false);

      //add fields to the User FieldSet
      TextField name = new TextField("Process Definition Name", "name", 210);
      name.setAllowBlank(false);
      name.setValue( parent.getName() );      
      fieldSet.add(name);

      TextField execs = new TextField("Number of executions", "numexec", 210);
      execs.setAllowBlank(false);
      execs.setValue( perf.getInstanceMetrics().size() +"" );
      fieldSet.add(execs);

      TextField average = new TextField("Average execution time", "average", 210);
      average.setValue(""+fixture[0]);
      fieldSet.add(average);

      TextField max = new TextField("Min execution time", "min", 210);
      max.setValue(""+ fixture[1]);
      fieldSet.add(max);

      TextField min = new TextField("Max execution time", "max", 210);
      min.setValue("" + fixture[2]);
      fieldSet.add(min);
      
      formPanel.add(fieldSet);

      panel.add(formPanel);


      // ----------------------------------------
      this.add(chartPanel);
      this.add(panel);

      // gchart hack
      chart.update();

   }

   private double[] deriveFixture(ProcessInstancePerformance perf)
   {
      double avg = -1;
      double min= -1;
      double max = -1;
      double sum = -1;

      Map metrics = perf.getInstanceMetrics();
      Iterator keys = metrics.keySet().iterator();

      while(keys.hasNext())
      {
         Long k = (Long)keys.next();
         Double v = (Double)metrics.get(k);
         
         if(min==-1) min = v.longValue();

         if(v.longValue()>max) max = v.longValue();
         else if(v.longValue()<=min) min = v.longValue();

         sum += v.longValue();

      }

      avg = Math.floor( sum/metrics.size());

      return new double[] {avg, min, max};
   }
}
