/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.metric;

import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.data.Store;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessDefinitionDAO;
import org.jboss.bpm.console.client.widgets.BarChart;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MetricOverview extends Panel
{

   private Map row2ProcessMap = new HashMap();
   private final MainView view;
   private int currentSelection=-1;

   public MetricOverview(final MainView view)
   {
      super();
      this.setHeader(false);
      this.setBorder(false);

      this.view = view;
      // ----------------------------------

      // stats
      Map barValues = new HashMap();

      barValues.put("Order Process", new Double(12.00));
      barValues.put("VacationManagement", new Double(24.00));
      barValues.put("New Employee walkthrough", new Double(5.00));
      barValues.put("Source code review", new Double(8.00));
      barValues.put("Loan application", new Double(54.00));
      barValues.put("Expense report review", new Double(10.00));

      BarChart chart = new BarChart(360,250, "Most used processes", "Process Name", barValues );
      chart.setLegendVisible(false);      

      Panel chartPanel = new Panel();
      chartPanel.setPaddings(10);
      chartPanel.setHeader(false);
      chartPanel.setBorder(false);
      chartPanel.setWidth(UIConstants.EDITOR_WIDTH);
      chartPanel.add( chart );
      
      // -------------------------------

      Panel panel = new Panel();
      panel.setBorder(false);
      panel.setPaddings(15);

      final FormPanel formPanel = new FormPanel();
      formPanel.setFrame(true);
      formPanel.setTitle("View process details");

      formPanel.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
      formPanel.setLabelWidth(75);
      //formPanel.setUrl("save-form.php");

      //create a Store using local array data
      final Store store = new SimpleStore(
        new String[]{"procId", "name", "version"}, getData()
      );
      store.load();

      final ComboBox cb = new ComboBox();
      cb.setForceSelection(true);
      cb.setMinChars(1);
      cb.setFieldLabel("Process");
      cb.setStore(store);
      cb.setDisplayField("name");
      cb.setMode(ComboBox.LOCAL);
      cb.setTriggerAction(ComboBox.ALL);
      cb.setEmptyText("Enter name");
      cb.setLoadingText("Searching...");
      cb.setTypeAhead(true);
      cb.setSelectOnFocus(true);
      cb.setWidth(300);

      cb.setHideTrigger(false);

      cb.addListener(
        new ComboBoxListenerAdapter()
        {

           public void onSelect(ComboBox comboBox, Record record, int i)
           {
              currentSelection = i;
           }
        }
      );

      // -------------------------------

      ButtonListenerAdapter listener = new ButtonListenerAdapter()
      {
         public void onClick(Button button, EventObject e)
         {
            if(currentSelection!=-1)
            {
               ProcessDefinition def = (ProcessDefinition)row2ProcessMap.get(new Integer(currentSelection));

               String editorId = MetricOverviewEditor.ID+"."+def.getName();
               if(view.hasEditor(editorId))
               {
                  view.showEditor(editorId);
               }
               else
               {
                  view.addEditor(new DefinitionMetricEditor(view, def));
               }
            }
            else
            {
               MessageBox.alert("Please select a process.");
            }
         }
      };
      Button button = new Button("View details", listener);

      formPanel.add(cb);
      formPanel.addButton(button);

      panel.add(formPanel);

      this.add(chartPanel);
      this.add(panel);
      
      // -------------------------------

      // required after ext init
      chart.update();
   }
   
   protected Object[][] getData()
   {
      ProcessDefinitionDAO dao = DAOFactory.createProcessDefinitionDAO();
      List processDefs = dao.getAllProcessDefinitions();

      Object[][] records = new Object[processDefs.size()][];

      Iterator it = processDefs.iterator();
      int row = 0;
      while(it.hasNext())
      {
         ProcessDefinition pd = (ProcessDefinition)it.next();
         records[row] = new Object[3];
         records[row][0] = new Long(pd.getProcessId());
         records[row][1] = pd.getName();
         records[row][2] = pd.getVersion();

         row2ProcessMap.put(new Integer(row), pd);

         row++;
      }

      return records;
   }
}
