/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.json.client.*;
import org.jboss.bpm.console.client.model.forms.FieldDef;
import org.jboss.bpm.console.client.model.forms.FormDef;
import org.jboss.bpm.console.client.util.JSONWalk;
import org.jboss.bpm.console.server.gson.GsonFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * TODO: run integrated (gwt-console-server) test
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class DTOParser
{
   public static List<String> parseRolesAssigned(String json)
   {
      // parse roles
      List<String> roles = new ArrayList<String>();

      // {"roles":[{"isAssigned":true,"role":"admin"},{"isAssigned":true,"role":"user"}]}

      JSONValue root = JSONParser.parse(json);
      JSONArray array = JSONWalk.on(root).next("roles").asArray();

      for (int i = 0; i < array.size(); ++i)
      {
         JSONObject item = array.get(i).isObject();
         boolean assigned = JSONWalk.on(item).next("isAssigned").asBool();
         String roleName = JSONWalk.on(item).next("role").asString();

         if(assigned)
         {
            roles.add(roleName);
         }
      }

      return roles;
   }

   public static List<TaskReference> parseTaskReferenceList(String json)
   {
      List<TaskReference> results = new ArrayList<TaskReference>();

      // {"tasks":[{"id":14,"name":"manager evaluation","isSignalling":true,
      // "isBlocking":false,"tokenId":6,"processInstanceId":4,"actor":"manager",
      // "transitionNames":["reject","approve"]}]}

      JSONValue root = JSONParser.parse(json);
      JSONArray array = JSONWalk.on(root).next("tasks").asArray();

      for (int i = 0; i < array.size(); ++i)
      {
         JSONObject item = array.get(i).isObject();
         TaskReference ref = parseTaskReference(item);
         results.add(ref);
      }

      return results;
   }

   public static TaskReference parseTaskReference(JSONObject item)
   {
      long id = JSONWalk.on(item).next("id").asLong();
      long tokenId = JSONWalk.on(item).next("tokenId").asLong();
      long instanceId = JSONWalk.on(item).next("processInstanceId").asLong();
      long processId = JSONWalk.on(item).next("processId").asLong();
      String name = JSONWalk.on(item).next("name").asString();
      String actor = JSONWalk.on(item).next("actor").asString();
      boolean isBlocking = JSONWalk.on(item).next("isBlocking").asBool();
      boolean isSignalling = JSONWalk.on(item).next("isSignalling").asBool();

      TaskReference ref = new TaskReference(
            id, tokenId, instanceId,
            processId,
            name, actor,
            isSignalling, isBlocking
      );

      if(isSignalling)
      {
         JSONArray arr = JSONWalk.on(item).next("transitionNames").asArray();
         for (int k = 0; k < arr.size(); ++k)
         {
            JSONString t = arr.get(k).isString();
            ref.getTransitionNames().add(t.stringValue());
         }
      }

      return ref;
   }

   public static Map<String,String> parseFormMapping(String json)
   {
      //[{"name":"update erp","value":"form.raise.erp-update.xhtml"}]
     
      throw new RuntimeException("Not implemented");
      
   }

   public static FormDef parseFormDef(String json)
   {
      return parseFormDef(JSONParser.parse(json));
   }

   public static FormDef parseFormDef(JSONValue root)
   { 
      // {"formName":"taskform-15",
      // "fields":[
      //    {"varname":"amount","label":"FirstName","required":true,"inputType":"TEXT",
      //    "dataTypeClass":"java.lang.String","defaults":[]}
      // ]}

      String formName = JSONWalk.on(root).next("formName").asString();
      FormDef formDef = new FormDef(formName);

      JSONArray array = JSONWalk.on(root).next("fields").asArray();
      for(int i=0; i<array.size(); i++)
      {
         JSONObject item = array.get(i).isObject();

         // fieldDefs
         String label = JSONWalk.on(item).next("label").asString();
         String varName = JSONWalk.on(item).next("varname").asString();
         boolean required = JSONWalk.on(item).next("required").asBool();
         FieldDef.InputType inputType = FieldDef.InputType.valueOf(
               JSONWalk.on(item).next("inputType").asString()
         );

         String dataType = JSONWalk.on(item).next("dataTypeClass").asString();

         // TODO: Parse defaults

         formDef.getFields().add(
               new FieldDef(label, varName, inputType, dataType,required)
         );
      }

      return formDef;
   }

}
