/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model.internal;

import org.jboss.bpm.console.client.model.HelpDAO;

import java.util.Map;
import java.util.HashMap;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockHelpDAO implements HelpDAO
{

   private static Map ref2text = new HashMap();

   static {
      ref2text.put(
        new Integer(HelpDAO.REF_PROCESS_DEFINITIONS),
        "Process definitions are the base classs for any process instance. " +
        "They act as an execution template for BPM engine"
      );

      ref2text.put(
        new Integer(HelpDAO.REF_PROCESS_METRIC),
        "The chart on the left displays the most used process definitions. " +
          "Usage is defined by the number of instances that have been created for a particular definition."
        );
   }

   public String getHelpByReference(int ref)
   {
      String text = (String)ref2text.get(new Integer(ref));
      if(text!=null)
         return text;
      else
         return "No help entry for ref: " + ref;      
   }
}
