/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model.internal;

import org.jboss.bpm.console.client.model.*;

import java.util.Map;
import java.util.HashMap;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockMetricsDAO implements MetricsDAO
{

   public final static double MAX_EXEC_TIME = 3600.00;

   public ProcessInstancePerformance getProcessInstancePerformance(long processId)
   {
      ProcessDefinition pd = DAOFactory.createProcessDefinitionDAO().getProcessDefinitionById(processId);
      
      ProcessInstancePerformance performance = new ProcessInstancePerformance(
        pd.getProcessId(), pd.getName(), generateInstanceMetrics(processId)
      );

      return performance;
   }

   private Map generateInstanceMetrics(long processId)
   {
      List instances = DAOFactory.createProcessInstanceDAO().getInstanceByProcessDefinitionId(processId);

      Map metrics = new HashMap();
      for(int i=0; i<instances.size(); i++)
      {
         ProcessInstance pi = (ProcessInstance)instances.get(i);
         metrics.put( new Long(pi.getInstanceId()) , new Double(Math.random()* MAX_EXEC_TIME) );
      }

      return metrics;
   }


   
}
