/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model.internal;

import org.jboss.bpm.console.client.model.ProcessDefinitionDAO;
import org.jboss.bpm.console.client.model.ProcessDefinition;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockProcessDefinitionDAO implements ProcessDefinitionDAO
{
   public final static List defs = new ArrayList();
   static
   {
      defs.add( new ProcessDefinition(1, "OrderProcess", "1"));
      defs.add( new ProcessDefinition(2, "VacationManagement", "1"));
      defs.add( new ProcessDefinition(3, "New Employee walkthrough", "1"));
      defs.add( new ProcessDefinition(4, "Source code review", "2"));
      defs.add( new ProcessDefinition(5, "Loan application", "1"));
      defs.add( new ProcessDefinition(6, "Expense report review", "4"));
      defs.add( new ProcessDefinition(7, "Expense claim", "4"));
      defs.add( new ProcessDefinition(8, "Credit approval", "4"));

   }

   public List getAllProcessDefinitions()
   {
      return defs;  
   }

   public ProcessDefinition getProcessDefinitionById(long id)
   {
      ProcessDefinition result = null;
      for(int i=0; i<defs.size(); i++)
      {
         ProcessDefinition pd = (ProcessDefinition)defs.get(i);
         if(pd.getProcessId() == id)
         {
            result = pd;
            break;
         }
      }
      return result;
   }
}
