/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model.internal;

import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.ProcessInstanceDAO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockProcessInstanceDAO implements ProcessInstanceDAO
{

   final static List instances = new ArrayList();
   static
   {
      instances.add( new ProcessInstance(2, -1, new Date(), null, false));
      instances.add( new ProcessInstance(3, -1, new Date(System.currentTimeMillis()-(1000*60*120)), new Date(System.currentTimeMillis()-(1000*60*12)), false));
      instances.add( new ProcessInstance(4, -1, new Date(System.currentTimeMillis()-(1000*60*60)), new Date(System.currentTimeMillis()-(1000*60*24)), false));
      instances.add( new ProcessInstance(5, -1, new Date(System.currentTimeMillis()-(1000*60*90)), new Date(System.currentTimeMillis()-(1000*60*17)), false));
      instances.add( new ProcessInstance(6, -1, new Date(), null, false));
      instances.add( new ProcessInstance(7, -1, new Date(), null, false));
   }


   public List getInstanceByProcessDefinitionId(long id)
   {
      return instances; 
   }
}
