/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.HTML;
import com.gwtext.client.core.Connection;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.*;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.FormListenerAdapter;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.layout.VerticalLayout;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.metric.MetricOverviewEditor;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.HelpDAO;
import org.jboss.bpm.console.client.widgets.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ProcessDefinitionListEditor extends Editor
{
   public final static String ID = "org.jboss.bpm.process.ProcessDefinitionListEditor";

   private ProcessDefinitionList processDefinitionList;

   private MainView view;

   private Panel teaserPanel;

   public ProcessDefinitionListEditor(final MainView view)
   {
      super();
      this.setId(ID);

      this.view = view;

      this.setLayout( new ColumnLayout() );
      this.setWidth(UIConstants.EDITOR_WIDTH);

      // ----------------------------------

      final Panel leftHand = new Panel();
      leftHand.setFrame(false);
      leftHand.setHeader(false);
      leftHand.setBorder(false);      
      
      processDefinitionList = new ProcessDefinitionList("Process Definitions", view);

      // ----------------------------------

      Panel outerFormPanel = new Panel();
      outerFormPanel.setBorder(false);
      outerFormPanel.setPaddings(10);
      

      final FormPanel formPanel = new FormPanel();
      formPanel.setFrame(true);
      formPanel.setTitle("Upload new process definition");
      formPanel.setLabelWidth(75);
      formPanel.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
     
      formPanel.setFileUpload(true);
      final TextField file = new TextField("File", "file");
      file.setInputType("file");      
      
      formPanel.add(file);

      Button uploadButton = new Button("Upload", new ButtonListenerAdapter()
      {
         public void onClick(Button button, EventObject e)
         {
            formPanel.getForm().submit(
              view.getUrlBuilder().getUploadDefinitionURL(), null,
              Connection.POST, "Uploading definition ...", false);
         }
      });      
      formPanel.addButton(uploadButton);
      formPanel.getForm().addListener(
        new FormListenerAdapter()
        {

           public boolean doBeforeAction(Form form)
           {              
              if(form.findField("file").getValueAsString().equals(""))
              {
                 MessageBox.alert("Please provide a process definition file");
                 return false;
              }
              
              return true;
           }

           public void onActionComplete(Form form, int i, String string)
           {
              processDefinitionList.reloadStore();
              leftHand.doLayout();
              form.reset();
           }

           public void onActionFailed(Form form, int i, String string)
           {
              super.onActionFailed(form, i, string);
              view.setError("Failed to upload process definition: " + string );
           }
        }
      );

      outerFormPanel.add(formPanel);

      // ----------------------------------

      // TODO: introduce abstractions and integrate with DAO
      Map chartValues = new HashMap();
      chartValues.put("1", new Double(0.65));
      chartValues.put("2", new Double(0.20));
      chartValues.put("3", new Double(0.10));
      chartValues.put("4", new Double(0.5));

      PieChart pieChart = new PieChart(180, 120, "", chartValues);
      Panel metricPanel = new Panel("Most active process", 200, 300);
      metricPanel.setLayout(new VerticalLayout());
      metricPanel.setIconCls("bpm-metric-icon");

      metricPanel.add(pieChart);
      HTML legend = new HTML(
        "<ol class='piechart-types'>" +
          "<li>1. Order Process" +
          "<li>2. Loan application" +
          "<li>3. Expense claim" +
          "<li>4. Credit approval" +
          "</ol>"
      );
      Panel legendPanel = new Panel();
      legendPanel.setBorder(false);
      legendPanel.setFrame(false);
      legendPanel.setHideBorders(true);
      legendPanel.setPaddings(5);
      legendPanel.add(legend);
      metricPanel.add(legendPanel);

      // toolbar

      Toolbar bottomToolbar = new Toolbar();
      bottomToolbar.addFill();
      bottomToolbar.addButton(
        new ToolbarButton("More metrics", new ButtonListenerAdapter() {
           public void onClick(Button button, EventObject e)
           {
              if(view.hasEditor(MetricOverviewEditor.ID))
              {
                 view.showEditor(MetricOverviewEditor.ID);
              }
              else
              {
                 view.addEditor( new MetricOverviewEditor(view) );
              }
           }
        })
      );

      metricPanel.setBottomToolbar(bottomToolbar);

      // ----------------------------------

      HelpPanel help = new HelpPanel(UIConstants.TEASER_PANEL_WIDTH, 180, "About process definitions");
      help.setContent( DAOFactory.createHelpDAO().getHelpByReference(HelpDAO.REF_PROCESS_DEFINITIONS));

      // ----------------------------------

      teaserPanel = new TeaserPanel();
      teaserPanel.add(help);
      teaserPanel.add(metricPanel);

      // ----------------------------------

      leftHand.add(processDefinitionList);
      leftHand.add(outerFormPanel);            
      
      this.add(leftHand, new ColumnLayoutData(0.7) );
      this.add(teaserPanel , new ColumnLayoutData(0.3) );

      // init gchart
      pieChart.update();

   }


   public String getEditorId()
   {
      return ID;
   }

   public String getTitle()
   {
      return "Processes";
   }

   public String getIconCSS()
   {
      return "bpm-process-icon";
   }

   public ProcessDefinitionList getProcessDefinitionList()
   {
      return processDefinitionList;
   }
}
