/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.ui.HTML;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.PanelListenerAdapter;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.jbpm3.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramNodeInfo;
import org.jboss.bpm.console.client.util.JSONRequest;
import org.jboss.bpm.console.client.util.JSONRequestHandler;
import org.jboss.bpm.console.client.util.JSONWalk;

/**
 * Fetches the {@link org.jboss.bpm.console.client.model.jbpm3.ActiveNodeInfo}
 * and displays the process image.<p>
 *
 * The {@link com.gwtext.client.widgets.event.PanelListenerAdapter#doBeforeRender(com.gwtext.client.widgets.Component)}
 * callback forces the GET request on the active node info, but has weak error handling and thus can result in 'null'.<br>
 *
 * The {@link com.gwtext.client.widgets.event.PanelListenerAdapter#onRender(com.gwtext.client.widgets.Component)}
 * callback fetches the process definition image, if available.
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ProcessImageView extends Panel
{
   private ProcessInstance instance;
   private MainView view;
   private ActiveNodeInfo activeNodeInfo = null;

   public ProcessImageView(final ProcessInstance instance, final MainView view)
   {
      super();
      this.instance = instance;
      this.view = view;

      this.setHeader(false);
      this.setBorder(true);
      this.setFrame(false);

      this.setAutoScroll(true);

      this.addListener(
        new PanelListenerAdapter()
        {
           public boolean doBeforeRender(Component component)
           {
              System.out.println("doBeforeRender");
              loadActiveNodeInfo();
              return true;
           }


           public void onRender(Component component)
           {
              System.out.println("onRender");
              /*final Image image = new Image("images/processSample.jpg");
              image.setStyleName("bpm-ProcessImage");
              add(image);*/


           }
        }
      );

   }

   private void loadActiveNodeInfo()
   {
      String url = view.getUrlBuilder().getActiveNodeInfoURL(this.instance.getInstanceId());
      System.out.println("Loading activeNodeInfo: " + url);

      JSONRequest.get(url,
        new JSONRequestHandler() {

           public void onRequestComplete(JavaScriptObject json)
           {

              //TODO: move to DTO Parser
              JSONObject root = new JSONObject(json);
              int diagramWidth = JSONWalk.on(root).next("diagramWidth").asInt();
              int diagramHeight = JSONWalk.on(root).next("diagramHeight").asInt();

              JSONObject activeNode = JSONWalk.on(root).next("activeNode").asObject();

              int x = JSONWalk.on(activeNode).next("x").asInt();
              int y = JSONWalk.on(activeNode).next("y").asInt();

              int width = JSONWalk.on(activeNode).next("width").asInt();
              int height = JSONWalk.on(activeNode).next("height").asInt();
              String name = JSONWalk.on(activeNode).next("name").asString();

              ActiveNodeInfo activeNodeInfo =
                new ActiveNodeInfo(
                  diagramWidth, diagramHeight,
                  new DiagramNodeInfo(name, x, y, width, height)
                );

              onActiveNodeInfoLoaded(activeNodeInfo);
           }
        }
      );

   }

   public void onActiveNodeInfoLoaded(ActiveNodeInfo activeNodeInfo)
   {
      System.out.println("Successfully loaded activeNodeInfo:" + activeNodeInfo.getActiveNode().getName());
      this.activeNodeInfo = activeNodeInfo;

      DiagramNodeInfo activeNode = activeNodeInfo.getActiveNode();
      String imageUrl = view.getUrlBuilder().getProcessImageURL(instance.getParentId());
      
      HTML html = new HTML(
        "<div id=\"imageContainer\" style=\"position:relative;top:-1;left:-1;height:"+activeNodeInfo.getHeight()+"px;width:"+activeNodeInfo.getWidth()+"px\">" +
          "<img src=\""+imageUrl+"\" style=\"position:absolute;top:0;left:0\" />" +
          "" +
          "<div class=\"activeNode\" style=\"top:"+ (activeNode.getY()) +"px;left:"+activeNode.getX()+"px;width:"+(activeNode.getWidth()-2)+"px;height:"+(activeNode.getHeight()-2)+"px\"></div>" +
          "" +
          "<div class=\"activeNode-header\" style=\"top:"+(activeNode.getY()-15)+"px;left:"+activeNode.getX()+"px;width:"+activeNode.getWidth()+"px;height:15px\">" +
          " <div class=\"activeNode-header-link\"><a href=\"javascript:alert('Not implemented!')\">Running</a></div>" +
          "</div>" +
          "</div>"
      );

      add(html);
      doLayout();

   }

   public ActiveNodeInfo getActiveNodeInfo()
   {
      return activeNodeInfo;
   }
}
