/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.gwtext.client.data.*;
import com.gwtext.client.widgets.*;
import com.gwtext.client.widgets.form.*;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.DTOParser;
import org.jboss.bpm.console.client.model.TaskReference;
import org.jboss.bpm.console.client.model.forms.FormDef;
import org.jboss.bpm.console.client.util.JSONRequest;
import org.jboss.bpm.console.client.util.JSONRequestHandler;
import org.jboss.bpm.console.client.widgets.RemoteListView;

import java.util.HashMap;
import java.util.Map;

/**
 * TODO: Buffer either generated form panels or at least the FormDef
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class TaskList extends RemoteListView
{
   private Map<Integer,TaskReference> row2taskref = new HashMap<Integer,TaskReference>();

   public TaskList(String titleName, final MainView view)
   {
      super(titleName, view,
            view.getUrlBuilder().getTaskListByActorURL(view.getRolesAssigned())
      );

      enableAddBtn(false);
      enableDeleteBtn(false);
   }

   protected void onAdd()
   {
      throw new RuntimeException("Tasks cannot be added manually!");
   }

   protected void onDelete(final int row)
   {
      throw new RuntimeException("Tasks cannot be deleted manually!");
   }

   protected void onExamine(final int row)
   {
      final TaskReference taskRef = row2taskref.get(row);
      String url = view.getUrlBuilder().getTaskFormDefURL(taskRef.getProcessId(), taskRef.getId());

      MessageBox.show(new MessageBoxConfig() {
         {
            setMsg("Generate form, please wait.");
            setProgressText("Loading...");
            setWidth(300);
            setWait(true);
            setWaitConfig(new WaitConfig() {
               {
                  setInterval(200);
               }
            });
         }
      });

      JSONRequest.get(url,
            new JSONRequestHandler() {

               public void onRequestComplete(JavaScriptObject json)
               {
                  JSONObject root = new JSONObject(json);
                  FormDef formDef = DTOParser.parseFormDef(root);

                  MessageBox.hide();

                  // generate form
                  FormPanel formPanel = new FormPanel();

                  // -----------

                  FieldSet fieldSet = new FieldSet();
                  fieldSet.setLabelWidth(90);
                  fieldSet.setTitle(taskRef.getName());
                  fieldSet.setAutoHeight(true);
                  fieldSet.setBorder(false);

                  // -----------
                  for(org.jboss.bpm.console.client.model.forms.FieldDef fieldDef : formDef.getFields())
                  {
                     switch(fieldDef.getInputType())
                     {
                        case TEXT:
                           fieldSet.add( new TextField(fieldDef.getLabel(), fieldDef.getVarname()) );
                           break;
                        case TEXTAREA:
                           fieldSet.add( new TextArea(fieldDef.getLabel(), fieldDef.getVarname()));
                           break;
                        case BOOL:
                           fieldSet.add( new Radio(fieldDef.getLabel(), fieldDef.getVarname()));
                           break;
                        default:
                           System.out.println("Unknown input type:" + fieldDef.getInputType());
                     }
                  }

                  // -----------

                  Panel inner = new PaddedPanel(fieldSet, 0, 10, 0, 0);
                  formPanel.add(inner);

                  // -----------
                  displayForm(formPanel);
               }
            }
      );
   }

   private void displayForm(FormPanel formPanel)
   {
      TaskListEditor parent = (TaskListEditor) ComponentMgr.getComponent(TaskListEditor.ID);
      Panel container = parent.getFormContainer();
      container.clear();
      container.add(formPanel);
      container.doLayout();
   }

   protected void onRecordsLoaded(Record[] records)
   {
      int i=0;
      for(Record r : records)
      {
         JavaScriptObject js = r.getDataAsJsObject();
         JSONObject jso = new JSONObject(js);
         TaskReference ref = DTOParser.parseTaskReference(jso);
         row2taskref.put(i, ref);
         i++;
      }

      System.out.println("Loaded " + row2taskref.size() + " tasks");
   }

   protected ColumnModel createColumnModel()
   {
      final ColumnModel columnModel = new ColumnModel(
            new ColumnConfig[]
                  {
                        new ColumnConfig("ID", "id", 75, true),
                        new ColumnConfig("Task Name", "name", 300, true, null, "expand"),
                        new ColumnConfig("Assigned to", "actor", 75, true)
                  }
      );
      return columnModel;
   }

   protected JsonReader createReader()
   {
      final RecordDef recordDef = new RecordDef(
            new FieldDef[]{
                  new IntegerFieldDef("id"),
                  new StringFieldDef("name"),
                  new StringFieldDef("actor")
            }
      );

      final JsonReader reader = new JsonReader(recordDef);
      reader.setRoot("tasks");
      reader.setTotalProperty("totalCount");
      reader.setId("id");
      return reader;
   }
}
