/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.task;

import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.widgets.TeaserPanel;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.event.PanelListenerAdapter;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class TaskListEditor extends Editor
{

   public final static String ID = "org.jboss.bpm.task.TaskList";
   private MainView mainView;
   private TaskList taskList;
   private Panel teaserPanel;
   private boolean initialized;

   private Panel formContainer;

   public TaskListEditor(MainView mainView )
   {
      super();
      this.setId(ID);
      this.mainView = mainView;

      this.setLayout( new ColumnLayout() );
      this.setWidth(UIConstants.EDITOR_WIDTH);

      this.addListener(
            new PanelListenerAdapter()
            {

               public boolean doBeforeRender(Component component)
               {
                  return beforeRenderCallback();
               }
            }
      );

   }

   public String getEditorId()
   {
      return ID;
   }

   public String getTitle()
   {
      return "Tasks";
   }

   public String getIconCSS()
   {
      return "bpm-task-icon";
   }

   /**
    * TaskList editor requires an authenticated user,
    * hence the initialization through callback
    */
   public boolean beforeRenderCallback()
   {
      if(!initialized)
      {
         final Panel leftHand = new Panel();
         leftHand.setFrame(false);
         leftHand.setHeader(false);
         leftHand.setBorder(false);

         // ----------------------------------

         taskList = new TaskList("Your tasks", mainView);
         leftHand.add(taskList);

         formContainer = new Panel();
         formContainer.setPaddings(10);
         formContainer.setBorder(false);
         leftHand.add(formContainer);
         
         // ----------------------------------

         teaserPanel = new TeaserPanel();

         // ----------------------------------

         this.add(leftHand, new ColumnLayoutData(0.7) );
         this.add(teaserPanel , new ColumnLayoutData(0.3) );

         doLayout();

         initialized = true;
      }

      return true;
   }

   public Panel getFormContainer()
   {
      return formContainer;
   }
}
