/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.widgets;

import com.googlecode.gchart.client.GChart;

import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class BarChart extends GChart
{
   String[] groupLabels;
   
   final static String BAR_COLOR = "#66CC66";

   final int MAX_REVENUE = 1000;
   
   public BarChart(int width, int height, String title, String groupName, Map barValues)
   {

      // limit to a single group
      this.groupLabels = new String[] { groupName };

      setChartSize(width, height);
      setChartTitle(title);
      setFontFamily("sans-serif");

      String[] labels = (String[])barValues.keySet().toArray( new String[]{} );
      
      for (int iCurve=0; iCurve < labels.length; iCurve++)
      {
         addCurve();     // one curve per quarter
         getCurve().getSymbol().setSymbolType(GChart.SymbolType.VBAR_SOUTHWEST);
         getCurve().getSymbol().setBackgroundColor(BAR_COLOR);
         getCurve().setLegendLabel(labels[iCurve]);

         getCurve().getSymbol().setHovertextTemplate(
           labels[iCurve]  + " value=${y}"
         );

         getCurve().getSymbol().setModelWidth(0.8);
         getCurve().getSymbol().setBorderColor("black");
         getCurve().getSymbol().setBorderWidth(1);
         for (int jGroup=0; jGroup < groupLabels.length; jGroup++)
         {
            // the '+1' creates a bar-sized gap between groups
            getCurve().addPoint(1+iCurve+jGroup*(labels.length+1), Math.random()*MAX_REVENUE);
            getCurve().getPoint().setAnnotationText(labels[iCurve]);
            getCurve().getPoint().setAnnotationLocation( GChart.AnnotationLocation.NORTH);
         }
      }

      for (int i = 0; i < groupLabels.length; i++)
      {
         // formula centers tick-label horizontally on each group
         getXAxis().addTick(
           labels.length/2. + i*(labels.length+1),
           groupLabels[i]
         );
         getXAxis().setTickLabelFontSize(20);
      }
      
      getXAxis().setTickLength(6);    // small tick-like gap...
      getXAxis().setTickThickness(0); // but with invisible ticks
      getXAxis().setAxisMin(0);       // keeps first bar on chart

      getYAxis().setAxisMin(0);           // Based on sim revenue range
      getYAxis().setAxisMax(MAX_REVENUE); // of 0 to MAX_REVENUE.
      getYAxis().setTickCount(11);
      getYAxis().setHasGridlines(true);
      getYAxis().setTickLabelFormat("###");
   }

}
