/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.widgets;

import com.googlecode.gchart.client.GChart;

import java.util.Map;
import java.util.Set;
import java.util.Iterator;

import org.jboss.bpm.console.client.model.internal.MockMetricsDAO;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class LineChart extends GChart
{
   /**
    *
    * @param metrics Long->Double
    */
   public LineChart(String title, int width, int height, Map metrics, String xLabel, String yLabel)
   {
      setChartTitle(title);
      setChartSize(width, height);
      setFontFamily("sans-serif");
      addCurve();

      // 2 pixel square connecting dots, spaced 5 pixels apart:
      getCurve().getSymbol().setFillThickness(2);
      getCurve().getSymbol().setFillSpacing(5);
      getCurve().getSymbol().setBackgroundColor("#66CC66");
      getCurve().getSymbol().setBorderColor("#66CC66");

      Iterator keys = metrics.keySet().iterator();
      int i=0;
      while(keys.hasNext())
      {
         Long k = (Long)keys.next(); 
         Double v = (Double)metrics.get(k);
         getCurve().addPoint(i, v.doubleValue() );

         getCurve().getPoint().setAnnotationVisible(true);
         getCurve().getPoint().setAnnotationText("ID " + k);
         getCurve().getPoint().setAnnotationLocation( GChart.AnnotationLocation.NORTH);
         i++;
      }


      getXAxis().setTickCount(metrics.size());
      getXAxis().setTickLength(6);    // small tick-like gap...
      getXAxis().setTickThickness(0); // but with invisible ticks
      getXAxis().setAxisMin(0);       // keeps first bar on chart
            
      getXAxis().setAxisLabel(xLabel);
      getYAxis().setAxisLabel(yLabel);
      getYAxis().setAxisMin(0);           // Based on sim revenue range
      getYAxis().setAxisMax(MockMetricsDAO.MAX_EXEC_TIME); // TODO: Fixme
      getYAxis().setTickCount(11);
   }
}
