/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.widgets;

import com.googlecode.gchart.client.GChart;

import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class PieChart extends GChart
{
   public PieChart(int width, int height, String title, Map typeValues)
   {      
      String[] pieColors = {"green", "red", "maroon", "yellow"};

      this.setChartSize(width, height);
      setChartTitle(title);
      this.setLegendVisible(false);

      getXAxis().setAxisVisible(false);
      getYAxis().setAxisVisible(false);
      getXAxis().setAxisMin(0);
      getXAxis().setAxisMax(10);
      getXAxis().setTickCount(0);
      getYAxis().setAxisMin(0);
      getYAxis().setAxisMax(10);
      getYAxis().setTickCount(0);

      // --------------------
      // this line orients the center of the first slice (apple) due east
      String[] pieTypes = (String[])typeValues.keySet().toArray(new String[] {});

      double[] pieValues = new double[pieTypes.length];
      for(int i=0; i<pieTypes.length; i++)
      {
         pieValues[i] = ((Double)typeValues.get(pieTypes[i])).doubleValue();   
      }

      // --------------------

      setInitialPieSliceOrientation(0.75 - pieValues[0]/2);
      for (int i=0; i < pieValues.length; i++)
      {
         addCurve();
         getCurve().addPoint(5,5);
         getCurve().getSymbol().setSymbolType( SymbolType.PIE_SLICE_OPTIMAL_SHADING );
         getCurve().getSymbol().setBorderColor("white");
         getCurve().getSymbol().setBackgroundColor(pieColors[i]);

         // next two lines define pie diameter as 6 x-axis model units
         getCurve().getSymbol().setModelWidth(6);
         getCurve().getSymbol().setHeight(0);
         getCurve().getSymbol().setFillSpacing(3);
         getCurve().getSymbol().setFillThickness(3);
         getCurve().getSymbol().setHovertextTemplate(pieTypes[i] + ", " + Math.round(100*pieValues[i])+"%");

         getCurve().getSymbol().setPieSliceSize(pieValues[i]);
         getCurve().getPoint().setAnnotationText( pieTypes[i] );
         getCurve().getPoint().setAnnotationLocation( AnnotationLocation.OUTSIDE_PIE_ARC);
      }
   }
}
