/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DefaultTypeAdapters;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSerializerExceptionWrapper;
import com.google.gson.ParameterizedTypeHandlerMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class DefaultTypeAdapters {
    private static final DefaultDateTypeAdapter DATE_TYPE_ADAPTER = new DefaultDateTypeAdapter(DateFormat.getDateTimeInstance());
    private static final EnumTypeAdapter ENUM_TYPE_ADAPTER = new EnumTypeAdapter(null);
    private static final UrlTypeAdapter URL_TYPE_ADAPTER = new UrlTypeAdapter(null);
    private static final UriTypeAdapter URI_TYPE_ADAPTER = new UriTypeAdapter(null);
    private static final LocaleTypeAdapter LOCALE_TYPE_ADAPTER = new LocaleTypeAdapter(null);
    private static final MapTypeAdapter MAP_TYPE_ADAPTER = new MapTypeAdapter();
    private static final BigDecimalTypeAdapter BIG_DECIMAL_TYPE_ADAPTER = new BigDecimalTypeAdapter(null);
    private static final BigIntegerTypeAdapter BIG_INTEGER_TYPE_ADAPTER = new BigIntegerTypeAdapter(null);
    private static final BooleanCreator BOOLEAN_CREATOR = new BooleanCreator(null);
    private static final ByteCreator BYTE_CREATOR = new ByteCreator(null);
    private static final CharacterCreator CHARACTER_CREATOR = new CharacterCreator(null);
    private static final DoubleCreator DOUBLE_CREATOR = new DoubleCreator(null);
    private static final FloatCreator FLOAT_CREATOR = new FloatCreator(null);
    private static final IntegerCreator INTEGER_CREATOR = new IntegerCreator(null);
    private static final LongCreator LONG_CREATOR = new LongCreator(null);
    private static final ShortCreator SHORT_CREATOR = new ShortCreator(null);
    private static final LinkedListCreator LINKED_LIST_CREATOR = new LinkedListCreator(null);
    private static final TreeSetCreator TREE_SET_CREATOR = new TreeSetCreator(null);
    static final ParameterizedTypeHandlerMap<JsonSerializer<?>> DEFAULT_SERIALIZERS = DefaultTypeAdapters.getDefaultSerializers();
    static final ParameterizedTypeHandlerMap<JsonDeserializer<?>> DEFAULT_DESERIALIZERS = DefaultTypeAdapters.getDefaultDeserializers();
    static final ParameterizedTypeHandlerMap<InstanceCreator<?>> DEFAULT_INSTANCE_CREATORS = DefaultTypeAdapters.getDefaultInstanceCreators();

    DefaultTypeAdapters() {
    }

    private static ParameterizedTypeHandlerMap<JsonSerializer<?>> getDefaultSerializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register(Enum.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)ENUM_TYPE_ADAPTER));
        map.register(URL.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)URL_TYPE_ADAPTER));
        map.register(URI.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)URI_TYPE_ADAPTER));
        map.register(Locale.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)LOCALE_TYPE_ADAPTER));
        map.register(Map.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)MAP_TYPE_ADAPTER));
        map.register(Date.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)DATE_TYPE_ADAPTER));
        map.register(BigDecimal.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)BIG_DECIMAL_TYPE_ADAPTER));
        map.register(BigInteger.class, (Object)DefaultTypeAdapters.wrapSerializer((JsonSerializer)BIG_INTEGER_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<JsonDeserializer<?>> getDefaultDeserializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register(Enum.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)ENUM_TYPE_ADAPTER));
        map.register(URL.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)URL_TYPE_ADAPTER));
        map.register(URI.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)URI_TYPE_ADAPTER));
        map.register(Locale.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)LOCALE_TYPE_ADAPTER));
        map.register(Map.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)MAP_TYPE_ADAPTER));
        map.register(Date.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)DATE_TYPE_ADAPTER));
        map.register(BigDecimal.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)BIG_DECIMAL_TYPE_ADAPTER));
        map.register(BigInteger.class, (Object)DefaultTypeAdapters.wrapDeserializer((JsonDeserializer)BIG_INTEGER_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<InstanceCreator<?>> getDefaultInstanceCreators() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register(Enum.class, (Object)ENUM_TYPE_ADAPTER);
        map.register(URL.class, (Object)URL_TYPE_ADAPTER);
        map.register(Locale.class, (Object)LOCALE_TYPE_ADAPTER);
        map.register(Map.class, (Object)MAP_TYPE_ADAPTER);
        map.register(BigDecimal.class, (Object)BIG_DECIMAL_TYPE_ADAPTER);
        map.register(BigInteger.class, (Object)BIG_INTEGER_TYPE_ADAPTER);
        map.register(Boolean.class, (Object)BOOLEAN_CREATOR);
        map.register(Boolean.TYPE, (Object)BOOLEAN_CREATOR);
        map.register(Byte.class, (Object)BYTE_CREATOR);
        map.register(Byte.TYPE, (Object)BYTE_CREATOR);
        map.register(Character.class, (Object)CHARACTER_CREATOR);
        map.register(Character.TYPE, (Object)CHARACTER_CREATOR);
        map.register(Double.class, (Object)DOUBLE_CREATOR);
        map.register(Double.TYPE, (Object)DOUBLE_CREATOR);
        map.register(Float.class, (Object)FLOAT_CREATOR);
        map.register(Float.TYPE, (Object)FLOAT_CREATOR);
        map.register(Integer.class, (Object)INTEGER_CREATOR);
        map.register(Integer.TYPE, (Object)INTEGER_CREATOR);
        map.register(Long.class, (Object)LONG_CREATOR);
        map.register(Long.TYPE, (Object)LONG_CREATOR);
        map.register(Short.class, (Object)SHORT_CREATOR);
        map.register(Short.TYPE, (Object)SHORT_CREATOR);
        map.register(Collection.class, (Object)LINKED_LIST_CREATOR);
        map.register(List.class, (Object)LINKED_LIST_CREATOR);
        map.register(Queue.class, (Object)LINKED_LIST_CREATOR);
        map.register(Set.class, (Object)TREE_SET_CREATOR);
        map.register(SortedSet.class, (Object)TREE_SET_CREATOR);
        map.makeUnmodifiable();
        return map;
    }

    private static JsonSerializer<?> wrapSerializer(JsonSerializer<?> serializer) {
        return new JsonSerializerExceptionWrapper(serializer);
    }

    private static JsonDeserializer<?> wrapDeserializer(JsonDeserializer<?> deserializer) {
        return new JsonDeserializerExceptionWrapper(deserializer);
    }
}

