/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonObject
extends JsonElement {
    private final Map<String, JsonElement> members = new LinkedHashMap();

    public void add(String property, JsonElement value) {
        this.members.put(property, value);
    }

    public void addProperty(String property, String value) {
        this.members.put(property, new JsonPrimitive(value));
    }

    public void addProperty(String property, Number value) {
        this.members.put(property, new JsonPrimitive(value));
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public JsonElement get(String memberName) {
        return (JsonElement)this.members.get(memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get(memberName);
    }

    protected void toString(StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry entry : this.members.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append((String)entry.getKey());
            sb.append("\":");
            ((JsonElement)entry.getValue()).toString(sb);
        }
        sb.append('}');
    }
}

