/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import com.gwtext.client.widgets.layout.VerticalLayout;
import java.util.List;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.Header;
import org.jboss.bpm.console.client.Menu;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.Workspace;
import org.jboss.bpm.console.client.metric.MetricOverviewEditor;
import org.jboss.bpm.console.client.process.ProcessDefinitionListEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainView
extends Composite {
    private HTML status = new HTML();
    private Header header;
    private Menu menu;
    private Workspace workspace;
    private URLBuilder urlBuilder = !GWT.isScript() ? new URLBuilder(GWT.getModuleBaseURL(), "xhp") : new URLBuilder("http://localhost:8080", "gwt-console-server");
    public static final String[] KNOWN_ROLES = new String[]{"admin", "manager", "user"};
    private Viewport viewport;
    private Authentication auth;

    public MainView() {
        Panel mainPanel = this.createMainPanel();
        this.assembleMainApplication(mainPanel);
        this.forceLogin(mainPanel);
        this.viewport = new Viewport(mainPanel);
    }

    private Panel createMainPanel() {
        Panel mainPanel = new Panel();
        mainPanel.setBorder(false);
        mainPanel.setPaddings(5);
        mainPanel.setLayout((ContainerLayout)new FitLayout());
        mainPanel.setWidth(1024);
        mainPanel.setHeight(1024);
        mainPanel.hide();
        this.initWidget((Widget)mainPanel);
        return mainPanel;
    }

    private void assembleMainApplication(Panel mainPanel) {
        Panel borderPanel = new Panel();
        borderPanel.setBorder(false);
        borderPanel.setLayout((ContainerLayout)new BorderLayout());
        this.header = new Header(this);
        borderPanel.add((Component)this.header, (LayoutData)new BorderLayoutData(RegionPosition.NORTH));
        this.menu = new Menu(this);
        BorderLayoutData menuData = new BorderLayoutData(RegionPosition.WEST);
        menuData.setSplit(false);
        menuData.setMinSize(175);
        menuData.setMaxSize(400);
        menuData.setMargins(new Margins(0, 5, 0, 0));
        borderPanel.add((Component)this.menu, (LayoutData)menuData);
        this.workspace = new Workspace();
        borderPanel.add((Component)this.workspace, (LayoutData)new BorderLayoutData(RegionPosition.CENTER));
        this.workspace.addEditor((Editor)new ProcessDefinitionListEditor(this), false);
        this.workspace.addEditor((Editor)new MetricOverviewEditor(this), false);
        mainPanel.add((Component)borderPanel);
    }

    private void forceLogin(Panel mainPanel) {
        Panel panel = new Panel();
        panel.setPaddings(20);
        panel.setStyleName("login-panel-content");
        panel.setLayout((ContainerLayout)new VerticalLayout(10));
        panel.add((Widget)new HTML("Welcome, please login."));
        Window window = new Window();
        window.setTitle("GWT-Console");
        window.setClosable(false);
        window.setResizable(false);
        window.setWidth(300);
        window.setHeight(180);
        window.setLayout((ContainerLayout)new BorderLayout());
        window.setCloseAction(Window.CLOSE);
        FormPanel loginForm = new FormPanel();
        loginForm.setBorder(false);
        loginForm.add((Component)new TextField("Username", "user"));
        TextField passwordField = new TextField("Password", "pass");
        passwordField.setPassword(true);
        loginForm.add((Component)passwordField);
        Button submitBtn = new Button("Login", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        loginForm.addButton(submitBtn);
        panel.add((Component)loginForm);
        BorderLayoutData centerData = new BorderLayoutData(RegionPosition.CENTER);
        centerData.setMargins(3, 0, 3, 3);
        window.add((Component)panel, (LayoutData)centerData);
        window.show();
    }

    public void addEditor(Editor editor) {
        this.workspace.addEditor(editor, true);
    }

    public boolean hasEditor(String id) {
        return this.workspace.hasEditor(id);
    }

    public void showEditor(String id) {
        this.workspace.showTab(id);
    }

    public URLBuilder getUrlBuilder() {
        return this.urlBuilder;
    }

    public void setError(String error) {
        this.displayMessage(error, true);
    }

    public void displayMessage(String message, boolean isError) {
        this.status.setText(message);
        MessageBox.show((MessageBoxConfig)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> getRolesAssigned() {
        return this.auth.getRolesAssigned();
    }

    public String getUsername() {
        return this.auth.getUsername();
    }

    public void logout() {
        this.auth.doLogout();
    }

    static /* synthetic */ Authentication access$002(MainView x0, Authentication x1) {
        x0.auth = x1;
        return x0.auth;
    }

    static /* synthetic */ Authentication access$000(MainView x0) {
        return x0.auth;
    }

    static /* synthetic */ Header access$100(MainView x0) {
        return x0.header;
    }
}

