/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import java.util.List;
import org.jboss.bpm.console.client.model.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLBuilder {
    private final String consoleServerUrl;
    private final String webContext;

    public URLBuilder(String consoleServerUrl, String webContext) {
        this.consoleServerUrl = consoleServerUrl;
        this.webContext = webContext;
    }

    public String getConsoleServerUrl() {
        return this.consoleServerUrl;
    }

    public String getWebContext() {
        return this.webContext;
    }

    private String getBaseUrl() {
        return this.consoleServerUrl + "/" + this.webContext;
    }

    public String getProcessDefinitionURL() {
        return this.getBaseUrl() + "/rs/process/definitions";
    }

    public String getProcessInstanceURL(long processId) {
        return this.getBaseUrl() + "/rs/process/definitions/" + processId + "/instances";
    }

    public String getUserInRoleURL(String[] possibleRoles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < possibleRoles.length; ++i) {
            sb.append(possibleRoles[i]);
            if (i >= possibleRoles.length - 1) continue;
            sb.append(",");
        }
        return this.getBaseUrl() + "/rs/user/roles?roleCheck=" + sb.toString();
    }

    @Deprecated
    public String getRemoveDefinitionURL(long processId) {
        return this.getBaseUrl() + "/rs/process/definitions/" + processId + "/remove";
    }

    public String getProcessImageURL(long processId) {
        return this.getBaseUrl() + "/rs/jbpm3/definitions/" + processId + "/image";
    }

    public String getDiagramInfoURL(long processId) {
        return this.getBaseUrl() + "/rs/jbpm3/definitions/" + processId + "/diagramInfo";
    }

    public String getActiveNodeInfoURL(long instanceId) {
        return this.getBaseUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
    }

    public String getStateChangeURL(long instanceId, ProcessInstance.STATE state) {
        return this.getBaseUrl() + "/rs/process/instances/" + instanceId + "/state/" + state;
    }

    public String getStartNewInstanceURL(long processId) {
        return this.getBaseUrl() + "/rs/process/definitions/" + processId + "/instances/new";
    }

    public String getUploadDefinitionURL() {
        return this.getBaseUrl() + "/rs/jbpm3/definitions/new";
    }

    public String getTaskListByActorURL(List<String> actors) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String s : actors) {
            sb.append(s);
            if (i < actors.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return this.getBaseUrl() + "/rs/tasks/actor?actors=" + sb.toString();
    }

    public String getTaskFormDefURL(long processId, long taskId) {
        return this.getBaseUrl() + "/rs/tasks/forms/" + processId + "/" + taskId;
    }
}

