/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.metric;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import java.util.Map;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstancePerformance;
import org.jboss.bpm.console.client.widgets.LineChart;

public class DefinitionMetricView
extends Panel {
    private ProcessDefinition parent;
    private MainView view;

    public DefinitionMetricView(MainView view, ProcessDefinition parent) {
        this.view = view;
        this.parent = parent;
        this.setHeader(false);
        this.setBorder(false);
        ProcessInstancePerformance perf = DAOFactory.createMetricsDAO().getProcessInstancePerformance(parent.getProcessId());
        LineChart chart = new LineChart(parent.getName() + " performance", 380, 260, perf.getInstanceMetrics(), "Instance", "t");
        double[] fixture = this.deriveFixture(perf);
        Panel chartPanel = new Panel();
        chartPanel.setPaddings(10);
        chartPanel.setHeader(false);
        chartPanel.setBorder(false);
        chartPanel.setWidth(680);
        chartPanel.add((Widget)chart);
        Panel panel = new Panel();
        panel.setBorder(false);
        panel.setFrame(false);
        panel.setPaddings(10);
        FormPanel formPanel = new FormPanel();
        formPanel.setLabelAlign(Position.LEFT);
        formPanel.setWidth(450);
        formPanel.setHeader(false);
        formPanel.setFrame(false);
        formPanel.setPaddings(5, 5, 5, 0);
        formPanel.setLabelWidth(120);
        FieldSet fieldSet = new FieldSet();
        fieldSet.setCheckboxToggle(false);
        fieldSet.setTitle("Process metrics");
        fieldSet.setCollapsed(false);
        fieldSet.setAutoHeight(true);
        fieldSet.setBorder(false);
        TextField name = new TextField("Process Definition Name", "name", 210);
        name.setAllowBlank(false);
        name.setValue(parent.getName());
        fieldSet.add((Component)name);
        TextField execs = new TextField("Number of executions", "numexec", 210);
        execs.setAllowBlank(false);
        execs.setValue(perf.getInstanceMetrics().size() + "");
        fieldSet.add((Component)execs);
        TextField average = new TextField("Average execution time", "average", 210);
        average.setValue("" + fixture[0]);
        fieldSet.add((Component)average);
        TextField max = new TextField("Min execution time", "min", 210);
        max.setValue("" + fixture[1]);
        fieldSet.add((Component)max);
        TextField min = new TextField("Max execution time", "max", 210);
        min.setValue("" + fixture[2]);
        fieldSet.add((Component)min);
        formPanel.add((Component)fieldSet);
        panel.add((Component)formPanel);
        this.add((Component)chartPanel);
        this.add((Component)panel);
        chart.update();
    }

    private double[] deriveFixture(ProcessInstancePerformance perf) {
        double avg = -1.0;
        double min = -1.0;
        double max = -1.0;
        double sum = -1.0;
        Map metrics = perf.getInstanceMetrics();
        for (Long k : metrics.keySet()) {
            Double v = (Double)metrics.get(k);
            if (min == -1.0) {
                min = v.longValue();
            }
            if ((double)v.longValue() > max) {
                max = v.longValue();
            } else if ((double)v.longValue() <= min) {
                min = v.longValue();
            }
            sum += (double)v.longValue();
        }
        avg = Math.floor(sum / (double)metrics.size());
        return new double[]{avg, min, max};
    }
}

