/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.metric;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.data.Store;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.event.ComboBoxListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.metric.MetricOverview;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessDefinitionDAO;
import org.jboss.bpm.console.client.widgets.BarChart;

public class MetricOverview
extends Panel {
    private Map row2ProcessMap = new HashMap();
    private final MainView view;
    private int currentSelection = -1;

    public MetricOverview(MainView view) {
        this.setHeader(false);
        this.setBorder(false);
        this.view = view;
        HashMap<String, Double> barValues = new HashMap<String, Double>();
        barValues.put("Order Process", new Double(12.0));
        barValues.put("VacationManagement", new Double(24.0));
        barValues.put("New Employee walkthrough", new Double(5.0));
        barValues.put("Source code review", new Double(8.0));
        barValues.put("Loan application", new Double(54.0));
        barValues.put("Expense report review", new Double(10.0));
        BarChart chart = new BarChart(360, 250, "Most used processes", "Process Name", barValues);
        chart.setLegendVisible(false);
        Panel chartPanel = new Panel();
        chartPanel.setPaddings(10);
        chartPanel.setHeader(false);
        chartPanel.setBorder(false);
        chartPanel.setWidth(680);
        chartPanel.add((Widget)chart);
        Panel panel = new Panel();
        panel.setBorder(false);
        panel.setPaddings(15);
        FormPanel formPanel = new FormPanel();
        formPanel.setFrame(true);
        formPanel.setTitle("View process details");
        formPanel.setWidth(450);
        formPanel.setLabelWidth(75);
        SimpleStore store = new SimpleStore(new String[]{"procId", "name", "version"}, this.getData());
        store.load();
        ComboBox cb = new ComboBox();
        cb.setForceSelection(true);
        cb.setMinChars(1);
        cb.setFieldLabel("Process");
        cb.setStore((Store)store);
        cb.setDisplayField("name");
        cb.setMode(ComboBox.LOCAL);
        cb.setTriggerAction(ComboBox.ALL);
        cb.setEmptyText("Enter name");
        cb.setLoadingText("Searching...");
        cb.setTypeAhead(true);
        cb.setSelectOnFocus(true);
        cb.setWidth(300);
        cb.setHideTrigger(false);
        cb.addListener((ComboBoxListener)new /* Unavailable Anonymous Inner Class!! */);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        Button button = new Button("View details", (ButtonListener)listener);
        formPanel.add((Component)cb);
        formPanel.addButton(button);
        panel.add((Component)formPanel);
        this.add((Component)chartPanel);
        this.add((Component)panel);
        chart.update();
    }

    protected Object[][] getData() {
        ProcessDefinitionDAO dao = DAOFactory.createProcessDefinitionDAO();
        List processDefs = dao.getAllProcessDefinitions();
        Object[][] records = new Object[processDefs.size()][];
        Iterator it = processDefs.iterator();
        int row = 0;
        while (it.hasNext()) {
            ProcessDefinition pd = (ProcessDefinition)it.next();
            records[row] = new Object[3];
            records[row][0] = new Long(pd.getProcessId());
            records[row][1] = pd.getName();
            records[row][2] = pd.getVersion();
            this.row2ProcessMap.put(new Integer(row), pd);
            ++row;
        }
        return records;
    }

    static /* synthetic */ int access$002(MetricOverview x0, int x1) {
        x0.currentSelection = x1;
        return x0.currentSelection;
    }

    static /* synthetic */ int access$000(MetricOverview x0) {
        return x0.currentSelection;
    }

    static /* synthetic */ Map access$100(MetricOverview x0) {
        return x0.row2ProcessMap;
    }
}

