/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.model.MetricsDAO;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.ProcessInstancePerformance;

public class MockMetricsDAO
implements MetricsDAO {
    public static final double MAX_EXEC_TIME = 3600.0;

    public ProcessInstancePerformance getProcessInstancePerformance(long processId) {
        ProcessDefinition pd = DAOFactory.createProcessDefinitionDAO().getProcessDefinitionById(processId);
        ProcessInstancePerformance performance = new ProcessInstancePerformance(pd.getProcessId(), pd.getName(), this.generateInstanceMetrics(processId));
        return performance;
    }

    private Map generateInstanceMetrics(long processId) {
        List instances = DAOFactory.createProcessInstanceDAO().getInstanceByProcessDefinitionId(processId);
        HashMap<Long, Double> metrics = new HashMap<Long, Double>();
        for (int i = 0; i < instances.size(); ++i) {
            ProcessInstance pi = (ProcessInstance)instances.get(i);
            metrics.put(new Long(pi.getInstanceId()), new Double(Math.random() * 3600.0));
        }
        return metrics;
    }
}

