/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.process.ProcessInstanceEditor;
import org.jboss.bpm.console.client.process.ProcessInstanceListEditor;
import org.jboss.bpm.console.client.widgets.RemoteListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ProcessDefinitionList
extends RemoteListView {
    private Map<Integer, ProcessDefinition> row2ProcessMap = new HashMap();

    public ProcessDefinitionList(String titleName, MainView view) {
        super(titleName, view, ProcessDefinitionList.getResourceUrl((MainView)view));
        this.enableAddBtn(false);
    }

    private static String getResourceUrl(MainView view) {
        return view.getUrlBuilder().getProcessDefinitionURL();
    }

    protected ColumnModel createColumnModel() {
        ColumnModel columnModel = new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new ColumnConfig("Process ID", "processId", 75, true), new ColumnConfig("Name", "name", 300, true, null, "expand"), new ColumnConfig("Version", "version", 75, true)});
        return columnModel;
    }

    protected JsonReader createReader() {
        RecordDef recordDef = new RecordDef(new FieldDef[]{new IntegerFieldDef("processId"), new StringFieldDef("name"), new StringFieldDef("version")});
        JsonReader reader = new JsonReader(recordDef);
        reader.setRoot("definitions");
        reader.setTotalProperty("totalCount");
        reader.setId("processId");
        return reader;
    }

    protected void onExamine(int row) {
        ProcessDefinition proc = (ProcessDefinition)this.row2ProcessMap.get(row);
        String editorId = ProcessInstanceEditor.createWidgetID((ProcessDefinition)proc);
        if (this.view.hasEditor(editorId)) {
            this.view.showEditor(editorId);
        } else {
            this.view.addEditor((Editor)new ProcessInstanceListEditor(proc, this.view));
        }
    }

    protected void onDelete(int row) {
        MessageBox.show((MessageBoxConfig)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onAdd() {
    }

    protected void onRecordsLoaded(Record[] records) {
        int i = 0;
        for (Record r : records) {
            Long id = Long.valueOf(r.getAsString("processId"));
            ProcessDefinition pd = new ProcessDefinition(id.longValue(), r.getAsString("name"), r.getAsString("version"));
            this.row2ProcessMap.put(i, pd);
            ++i;
        }
        System.out.println("Loaded " + this.row2ProcessMap.size() + " process definitions");
    }

    public List<ProcessDefinition> getAvailableProcessDefinitions() {
        ArrayList<ProcessDefinition> results = new ArrayList<ProcessDefinition>();
        Iterator keys = this.row2ProcessMap.keySet().iterator();
        while (keys.hasNext()) {
            results.add((ProcessDefinition)this.row2ProcessMap.get(keys.next()));
        }
        return results;
    }

    static /* synthetic */ Map access$000(ProcessDefinitionList x0) {
        return x0.row2ProcessMap;
    }

    static /* synthetic */ MainView access$100(ProcessDefinitionList x0) {
        return x0.view;
    }

    static /* synthetic */ MainView access$200(ProcessDefinitionList x0) {
        return x0.view;
    }

    static /* synthetic */ MainView access$300(ProcessDefinitionList x0) {
        return x0.view;
    }
}

