/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.FormListener;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import com.gwtext.client.widgets.layout.VerticalLayout;
import java.util.HashMap;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.DAOFactory;
import org.jboss.bpm.console.client.process.ProcessDefinitionList;
import org.jboss.bpm.console.client.widgets.HelpPanel;
import org.jboss.bpm.console.client.widgets.PieChart;
import org.jboss.bpm.console.client.widgets.TeaserPanel;

public class ProcessDefinitionListEditor
extends Editor {
    public static final String ID = "org.jboss.bpm.process.ProcessDefinitionListEditor";
    private ProcessDefinitionList processDefinitionList;
    private MainView view;
    private Panel teaserPanel;

    public ProcessDefinitionListEditor(MainView view) {
        this.setId(ID);
        this.view = view;
        this.setLayout((ContainerLayout)new ColumnLayout());
        this.setWidth(680);
        Panel leftHand = new Panel();
        leftHand.setFrame(false);
        leftHand.setHeader(false);
        leftHand.setBorder(false);
        this.processDefinitionList = new ProcessDefinitionList("Process Definitions", view);
        Panel outerFormPanel = new Panel();
        outerFormPanel.setBorder(false);
        outerFormPanel.setPaddings(10);
        FormPanel formPanel = new FormPanel();
        formPanel.setFrame(true);
        formPanel.setTitle("Upload new process definition");
        formPanel.setLabelWidth(75);
        formPanel.setWidth(450);
        formPanel.setFileUpload(true);
        TextField file = new TextField("File", "file");
        file.setInputType("file");
        formPanel.add((Component)file);
        Button uploadButton = new Button("Upload", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        formPanel.addButton(uploadButton);
        formPanel.getForm().addListener((FormListener)new /* Unavailable Anonymous Inner Class!! */);
        outerFormPanel.add((Component)formPanel);
        HashMap<String, Double> chartValues = new HashMap<String, Double>();
        chartValues.put("1", new Double(0.65));
        chartValues.put("2", new Double(0.2));
        chartValues.put("3", new Double(0.1));
        chartValues.put("4", new Double(0.5));
        PieChart pieChart = new PieChart(180, 120, "", chartValues);
        Panel metricPanel = new Panel("Most active process", 200, 300);
        metricPanel.setLayout((ContainerLayout)new VerticalLayout());
        metricPanel.setIconCls("bpm-metric-icon");
        metricPanel.add((Widget)pieChart);
        HTML legend = new HTML("<ol class='piechart-types'><li>1. Order Process<li>2. Loan application<li>3. Expense claim<li>4. Credit approval</ol>");
        Panel legendPanel = new Panel();
        legendPanel.setBorder(false);
        legendPanel.setFrame(false);
        legendPanel.setHideBorders(true);
        legendPanel.setPaddings(5);
        legendPanel.add((Widget)legend);
        metricPanel.add((Component)legendPanel);
        Toolbar bottomToolbar = new Toolbar();
        bottomToolbar.addFill();
        bottomToolbar.addButton(new ToolbarButton("More metrics", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */));
        metricPanel.setBottomToolbar(bottomToolbar);
        HelpPanel help = new HelpPanel(200, 180, "About process definitions");
        help.setContent(DAOFactory.createHelpDAO().getHelpByReference(100));
        this.teaserPanel = new TeaserPanel();
        this.teaserPanel.add((Component)help);
        this.teaserPanel.add((Component)metricPanel);
        leftHand.add((Component)this.processDefinitionList);
        leftHand.add((Component)outerFormPanel);
        this.add((Component)leftHand, (LayoutData)new ColumnLayoutData(0.7));
        this.add((Component)this.teaserPanel, (LayoutData)new ColumnLayoutData(0.3));
        pieChart.update();
    }

    public String getEditorId() {
        return ID;
    }

    public String getTitle() {
        return "Processes";
    }

    public String getIconCSS() {
        return "bpm-process-icon";
    }

    public ProcessDefinitionList getProcessDefinitionList() {
        return this.processDefinitionList;
    }

    static /* synthetic */ ProcessDefinitionList access$000(ProcessDefinitionListEditor x0) {
        return x0.processDefinitionList;
    }
}

