/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.PaddedPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.process.ProcessImageView;
import org.jboss.bpm.console.client.widgets.HelpPanel;
import org.jboss.bpm.console.client.widgets.TeaserPanel;

public class ProcessInstanceEditor
extends Editor {
    public static final String ID = "org.jboss.bpm.process.ProcessInstance";
    private ProcessDefinition processDefinition;
    private ProcessInstance processInstance;
    private MainView view;
    private Panel teaserPanel;

    public ProcessInstanceEditor(ProcessDefinition proc, ProcessInstance instance, MainView view) {
        this.setId("org.jboss.bpm.process.ProcessInstance." + instance.getInstanceId());
        this.processDefinition = proc;
        this.processInstance = instance;
        this.view = view;
        this.setPaddings(10);
        this.setWidth(680);
        this.setLayout((ContainerLayout)new ColumnLayout());
        this.setBorder(false);
        this.setHeader(false);
        ProcessImageView imageView = new ProcessImageView(instance, view);
        imageView.setWidth(450);
        Toolbar imageToolbar = new Toolbar();
        imageToolbar.addFill();
        ToolbarButton toolbarButton = new ToolbarButton("Enlarge", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbarButton.setIconCls("bpm-enlarge-icon");
        imageToolbar.addButton(toolbarButton);
        imageView.setBottomToolbar(imageToolbar);
        PaddedPanel rightPanel = new PaddedPanel((Panel)imageView, 5, 5, 0, 5);
        this.teaserPanel = new TeaserPanel();
        HelpPanel taskPanel = new HelpPanel(200, 180, "Associated Tasks");
        taskPanel.setIconCls("bpm-task-icon");
        taskPanel.setContent("Process instances can have user tasks associated with them. These tasks will cross referenced here.");
        Toolbar bottomToolbar = new Toolbar();
        bottomToolbar.addFill();
        ToolbarButton taskBtn = new ToolbarButton("View tasks", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        taskBtn.setIconCls("bpm-switch-context-icon");
        bottomToolbar.addButton(taskBtn);
        taskPanel.setBottomToolbar(bottomToolbar);
        this.teaserPanel.add((Component)taskPanel);
        HelpPanel commentPanel = new HelpPanel(200, 180, "Leave a comment");
        commentPanel.setIconCls("bpm-comment-icon");
        commentPanel.setContent("Users can leave comments about processes and process instances in particular. This teaser will launch the comment form/list view");
        Toolbar bottomToolbar2 = new Toolbar();
        bottomToolbar2.addFill();
        bottomToolbar2.addButton(new ToolbarButton("View/Add comments", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */));
        commentPanel.setBottomToolbar(bottomToolbar2);
        this.teaserPanel.add((Component)commentPanel);
        this.add((Component)rightPanel, (LayoutData)new ColumnLayoutData(0.7));
        this.add((Component)this.teaserPanel, (LayoutData)new ColumnLayoutData(0.3));
    }

    public String getEditorId() {
        return ID;
    }

    public String getTitle() {
        return "#" + this.processInstance.getInstanceId() + " (" + this.processDefinition.getName() + ")";
    }

    public String getIconCSS() {
        return "bpm-instance-icon";
    }

    public static String createWidgetID(ProcessDefinition parent) {
        return "org.jboss.bpm.process.ProcessInstance." + parent.getName() + "." + parent.getVersion();
    }
}

