/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.widgets;

import com.googlecode.gchart.client.GChart;
import java.util.Map;

public class BarChart
extends GChart {
    String[] groupLabels;
    static final String BAR_COLOR = "#66CC66";
    final int MAX_REVENUE = 1000;

    public BarChart(int width, int height, String title, String groupName, Map barValues) {
        this.groupLabels = new String[]{groupName};
        this.setChartSize(width, height);
        this.setChartTitle(title);
        this.setFontFamily("sans-serif");
        String[] labels = barValues.keySet().toArray(new String[0]);
        for (int iCurve = 0; iCurve < labels.length; ++iCurve) {
            this.addCurve();
            this.getCurve().getSymbol().setSymbolType(GChart.SymbolType.VBAR_SOUTHWEST);
            this.getCurve().getSymbol().setBackgroundColor(BAR_COLOR);
            this.getCurve().setLegendLabel(labels[iCurve]);
            this.getCurve().getSymbol().setHovertextTemplate(labels[iCurve] + " value=${y}");
            this.getCurve().getSymbol().setModelWidth(0.8);
            this.getCurve().getSymbol().setBorderColor("black");
            this.getCurve().getSymbol().setBorderWidth(1);
            for (int jGroup = 0; jGroup < this.groupLabels.length; ++jGroup) {
                this.getCurve().addPoint((double)(1 + iCurve + jGroup * (labels.length + 1)), Math.random() * 1000.0);
                this.getCurve().getPoint().setAnnotationText(labels[iCurve]);
                this.getCurve().getPoint().setAnnotationLocation(GChart.AnnotationLocation.NORTH);
            }
        }
        for (int i = 0; i < this.groupLabels.length; ++i) {
            this.getXAxis().addTick((double)labels.length / 2.0 + (double)(i * (labels.length + 1)), this.groupLabels[i]);
            this.getXAxis().setTickLabelFontSize(20);
        }
        this.getXAxis().setTickLength(6);
        this.getXAxis().setTickThickness(0);
        this.getXAxis().setAxisMin(0.0);
        this.getYAxis().setAxisMin(0.0);
        this.getYAxis().setAxisMax(1000.0);
        this.getYAxis().setTickCount(11);
        this.getYAxis().setHasGridlines(true);
        this.getYAxis().setTickLabelFormat("###");
    }
}

