/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.widgets;

import com.googlecode.gchart.client.GChart;
import java.util.Map;

public class PieChart
extends GChart {
    public PieChart(int width, int height, String title, Map typeValues) {
        int i;
        String[] pieColors = new String[]{"green", "red", "maroon", "yellow"};
        this.setChartSize(width, height);
        this.setChartTitle(title);
        this.setLegendVisible(false);
        this.getXAxis().setAxisVisible(false);
        this.getYAxis().setAxisVisible(false);
        this.getXAxis().setAxisMin(0.0);
        this.getXAxis().setAxisMax(10.0);
        this.getXAxis().setTickCount(0);
        this.getYAxis().setAxisMin(0.0);
        this.getYAxis().setAxisMax(10.0);
        this.getYAxis().setTickCount(0);
        String[] pieTypes = typeValues.keySet().toArray(new String[0]);
        double[] pieValues = new double[pieTypes.length];
        for (i = 0; i < pieTypes.length; ++i) {
            pieValues[i] = (Double)typeValues.get(pieTypes[i]);
        }
        this.setInitialPieSliceOrientation(0.75 - pieValues[0] / 2.0);
        for (i = 0; i < pieValues.length; ++i) {
            this.addCurve();
            this.getCurve().addPoint(5.0, 5.0);
            this.getCurve().getSymbol().setSymbolType(GChart.SymbolType.PIE_SLICE_OPTIMAL_SHADING);
            this.getCurve().getSymbol().setBorderColor("white");
            this.getCurve().getSymbol().setBackgroundColor(pieColors[i]);
            this.getCurve().getSymbol().setModelWidth(6.0);
            this.getCurve().getSymbol().setHeight(0);
            this.getCurve().getSymbol().setFillSpacing(3.0);
            this.getCurve().getSymbol().setFillThickness(3);
            this.getCurve().getSymbol().setHovertextTemplate(pieTypes[i] + ", " + Math.round(100.0 * pieValues[i]) + "%");
            this.getCurve().getSymbol().setPieSliceSize(pieValues[i]);
            this.getCurve().getPoint().setAnnotationText(pieTypes[i]);
            this.getCurve().getPoint().setAnnotationLocation(GChart.AnnotationLocation.OUTSIDE_PIE_ARC);
        }
    }
}

