/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.widgets;

import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.ScriptTagProxy;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.event.StoreListener;
import com.gwtext.client.widgets.PagingToolbar;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.widgets.RemoteListView;

public abstract class RemoteListView
extends Panel {
    protected int selectedRowIndex = -1;
    protected MainView view;
    protected static final int PAGE_SIZE = 25;
    private GridPanel grid;
    protected String title;
    private Store store;
    private PagingToolbar pagingToolbar;
    private boolean storeInit = false;
    private ToolbarButton addButton;
    private ToolbarButton deleteButton;

    public RemoteListView(String titleName, MainView view, String resourceUrl) {
        this.title = titleName;
        this.view = view;
        this.setPaddings(10);
        this.setHeader(false);
        this.setBorder(false);
        this.setFrame(false);
        this.grid = this.createGridPanel(titleName);
        JsonReader reader = this.createReader();
        ColumnModel columnModel = this.createColumnModel();
        this.grid.setColumnModel(columnModel);
        this.grid.setAutoExpandColumn("expand");
        ScriptTagProxy dataProxy = new ScriptTagProxy(resourceUrl, 10000);
        this.store = new Store((DataProxy)dataProxy, (Reader)reader, false);
        this.store.addStoreListener((StoreListener)new ListViewStoreListener(this, (Panel)this, this.grid));
        this.grid.setStore(this.store);
        this.pagingToolbar = this.createToolbar(this.store);
        this.grid.setBottomToolbar((Toolbar)this.pagingToolbar);
        this.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void enableAddBtn(boolean isEnabled) {
        if (isEnabled) {
            this.addButton.enable();
        } else {
            this.addButton.disable();
        }
    }

    protected void enableDeleteBtn(boolean isEnabled) {
        if (isEnabled) {
            this.deleteButton.enable();
        } else {
            this.deleteButton.disable();
        }
    }

    private GridPanel createGridPanel(String titleName) {
        GridPanel grid = new GridPanel();
        grid.setTitle(titleName);
        grid.setFrame(true);
        grid.setWidth(450);
        grid.stripeRows(true);
        grid.setLoadMask(true);
        grid.addGridCellListener((GridCellListener)new ListViewCellListener(this, null));
        return grid;
    }

    private PagingToolbar createToolbar(Store store) {
        PagingToolbar pagingToolbar = new PagingToolbar(store);
        pagingToolbar.setPageSize(25);
        pagingToolbar.setDisplayInfo(true);
        pagingToolbar.setDisplayMsg("{0} - {1} of {2}");
        pagingToolbar.addSeparator();
        pagingToolbar.addSpacer();
        ToolbarButton examineButton = new ToolbarButton("Examine", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        examineButton.setTooltip("Examine");
        pagingToolbar.addButton(examineButton);
        this.addButton = new ToolbarButton("Add", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addButton.setTooltip("Add");
        pagingToolbar.addButton(this.addButton);
        this.deleteButton = new ToolbarButton("Remove", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setTooltip("Remove");
        pagingToolbar.addButton(this.deleteButton);
        return pagingToolbar;
    }

    protected abstract void onAdd();

    protected abstract void onExamine(int var1);

    protected abstract void onDelete(int var1);

    protected abstract void onRecordsLoaded(Record[] var1);

    protected abstract ColumnModel createColumnModel();

    protected abstract JsonReader createReader();

    public GridPanel getGrid() {
        return this.grid;
    }

    public void reloadStore() {
        this.store.load(0, 25);
    }

    static /* synthetic */ boolean access$100(RemoteListView x0) {
        return x0.storeInit;
    }

    static /* synthetic */ boolean access$102(RemoteListView x0, boolean x1) {
        x0.storeInit = x1;
        return x0.storeInit;
    }
}

