package org.jboss.bpm.console.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.Response;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.VerticalLayout;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.RegionPosition;
import org.jboss.bpm.console.client.util.ConsoleLog;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 * Does the authentication and reads the comfiguration before launching
 * the {@link org.jboss.bpm.console.client.MainView}
 */
public class Application implements EntryPoint
{
   private MainView mainView;
   private Authentication auth;
   private ConsoleConfig config;
   private URLBuilder urlBuilder;

   public final static String[] KNOWN_ROLES = {"admin", "manager", "user"};

   /**
    * Note, we defer all application initialization code to
    * {@link #onModuleLoad2()} so that the UncaughtExceptionHandler
    * can catch any unexpected exceptions.
    */
   public void onModuleLoad() {

      ConsoleLog.setEnabled(true);

      /* Install an UncaughtExceptionHandler which will
      * produce <code>FATAL</code> log messages
      */
      ConsoleLog.setUncaughtExceptionHandler();

      /* Use a deferred command so that the UncaughtExceptionHandler
      * catches any exceptions in onModuleLoad2()
      */
      DeferredCommand.addCommand(new Command() {
         public void execute() {
            onModuleLoad2();
         }
      });
   }

   /**
    * This is the entry point method.
    */
   public void onModuleLoad2()
   {
      config = new ConsoleConfig();

      // setup

      if(!GWT.isScript())
      {
         String proxyUrl = GWT.getModuleBaseURL() + "xhp";
         config.setConsoleServerUrl(proxyUrl);         
      }

      ConsoleLog.debug("Console server: " + config.getConsoleServerUrl());
      ConsoleLog.debug("Report server: " + config.getReportServerUrl());

      urlBuilder = new URLBuilder(config);

      // authentiction
      
      forceLogin();
   }

   public MainView getConsoleView()
   {
      return mainView;
   }

   private void forceLogin()
   {
      Panel panel = new Panel();
      panel.setPaddings(20);
      panel.setStyleName("login-panel-content");
      panel.setLayout(new VerticalLayout(10));
      panel.add( new HTML("Welcome, please login.") );

      final Window window = new Window();
      window.setTitle("GWT-Console");
      window.setClosable(false);
      window.setResizable(false);
      window.setWidth(300);
      window.setHeight(180);
      window.setLayout(new BorderLayout());
      window.setCloseAction(Window.CLOSE);

      final FormPanel loginForm = new FormPanel();
      loginForm.setBorder(false);
      loginForm.add(new TextField("Username", "user"));
      TextField passwordField = new TextField("Password", "pass");
      passwordField.setPassword(true);
      loginForm.add(passwordField);

      final Button submitBtn = new Button("Login",
            new ButtonListenerAdapter()
            {
               public void onClick(Button button, EventObject e)
               {
                  String user = loginForm.getForm().findField("user").getValueAsString();
                  String pass = loginForm.getForm().findField("pass").getValueAsString();

                  String url = urlBuilder.getUserInRoleURL(KNOWN_ROLES);
                  auth = new Authentication(url);
                  auth.setCallback(
                        new Authentication.AuthCallback()
                        {

                           public void onLoginSuccess(Request request, Response response)
                           {
                              // clear the form
                              loginForm.getForm().reset();

                              // display main console
                              window.close();

                              // assemble main view
                              mainView = new MainView(auth, urlBuilder, config);
                           }

                           public void onLoginFailed(Request request, Throwable t)
                           {
                              // auth failed
                              ConsoleLog.error("Authentication failed.", t);
                           }
                        }
                  );

                  auth.doLogin(user,pass);

               }
            });

      loginForm.addButton(submitBtn);
      panel.add(loginForm);

      BorderLayoutData centerData = new BorderLayoutData(RegionPosition.CENTER);
      centerData.setMargins(3, 0, 3, 3);

      window.add(panel, centerData);
      // ------------------------------------------

      window.show();
   }

}
