/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.layout.*;
import com.gwtext.client.core.EventObject;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;

import java.util.List;

import org.jboss.bpm.console.client.widgets.HelpPanel;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Header extends Panel
{
   private MainView view;
   
   public final static String ID = "org.jboss.bpm.headerPanel";
   
   public Header(MainView view)
   {
      super();
      this.view = view;
      this.setId(ID);

      this.setFrame(false);
      this.setBorder(false);
      this.setHeader(false);

      //HorizontalLayout layout = new HorizontalLayout(20);
      //this.setLayout(layout);

      this.setHeight(50);
      this.setBaseCls("bpm-header");
   }

   public void setUserInfo(String username, List<String> roles)
   {
      Panel userInfo = new Panel();
      userInfo.setBorder(false);
      userInfo.setHeader(false);
      userInfo.setFrame(false);
      userInfo.setStyleName("bpm-header-userinfo");
      HorizontalLayout layout = new HorizontalLayout(10);
      userInfo.setLayout(layout);

      userInfo.add( new Image("images/icons/05.png") );
      userInfo.add( new HTML(view.getUsername()));
      userInfo.add(
            new Button("Logout",
                  new ButtonListenerAdapter(){

                     public void onClick(Button button, EventObject eventObject)
                     {
                        view.logout();
                     }
                  }
            )
      );

      //this.clear();
      this.add(userInfo);
      //this.doLayout();
      
   }
}
