/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.http.client.URL;
import com.google.gwt.core.client.GWT;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class URLBuilder
{
   ConsoleConfig config;

   public URLBuilder(ConsoleConfig config)
   {
      this.config = config;
   }

   public String getConsoleServerUrl()
   {
      return config.getConsoleServerUrl();
   }

   public String getProcessDefinitionsURL()
   {
      return getConsoleServerUrl() + "/rs/process/definitions";
   }

   public String getProcessInstancesURL(long processId)
   {
      return getConsoleServerUrl() + "/rs/process/definitions/"+processId+"/instances";
   }

   public String getUserInRoleURL(String[] possibleRoles)
   {
      StringBuffer sb = new StringBuffer();
      for(int i=0; i<possibleRoles.length; i++)
      {
         sb.append(URL.encode(possibleRoles[i]));
         if(i<possibleRoles.length-1)
            sb.append(",");
      }
      return getConsoleServerUrl() + "/rs/identity/user/roles?roleCheck="+sb.toString();
   }

   @Deprecated
   public String getRemoveDefinitionURL(long processId)
   {
      return getConsoleServerUrl() + "/rs/process/definitions/" + processId + "/remove";
   }

   public String getProcessImageURL(long processId)
   {
      return getConsoleServerUrl() + "/rs/jbpm3/definitions/" + processId + "/image";
   }

   public String getDiagramInfoURL(long processId)
   {
      return getConsoleServerUrl() + "/rs/jbpm3/definitions/" + processId + "/diagramInfo";
   }

   public String getActiveNodeInfoURL(long instanceId)
   {
      return getConsoleServerUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
   }

   public String getStateChangeURL(long instanceId, ProcessInstanceRef.STATE state)
   {
      return getConsoleServerUrl() + "/rs/process/instances/" + instanceId + "/state/"+state;
   }

   public String getStartNewInstanceURL(long processId)
   {
      return getConsoleServerUrl() + "/rs/process/definitions/"+processId+"/instances/new";
   }

   public String getUploadDefinitionURL()
   {
      return getConsoleServerUrl() + "/rs/jbpm3/definitions/new";
   }

   public String getTaskListByActorURL(String actor)
   {
      return getConsoleServerUrl() + "/rs/tasks/actor/"+URL.encode(actor);
   }

   public String getTaskFormDefURL(long processId, long taskId)
   {
      return getConsoleServerUrl() + "/rs/tasks/forms/"+processId+"/"+taskId;
   }

   public String getTaskEndURL(long id)
   {
      return getConsoleServerUrl() + "/rs/tasks/"+id+"/close/transition/default";
   }

   public String getTaskEndURL(long id, String signalName)
   {      
      return getConsoleServerUrl() + "/rs/tasks/"+id+"/close/transition?signal=" + URL.encode(signalName);
   }

   public String getTaskAssignmentURL(long id, String actor)
   {
      String actualActor = actor == null ? "" : "/"+actor;
      return getConsoleServerUrl() + "/rs/tasks/"+id+"/assignment"+URL.encode(actualActor);
   }

   public String getTokenSignalUrl(TokenReference tok)
   {
      return getConsoleServerUrl() + "/rs/jbpm3/tokens/"+tok.getId()+"/transition/default";
   }

   public String getTokenSignalUrl(TokenReference tok, String signal)
   {
      String encodedSignal = URL.encode(signal);
      return getConsoleServerUrl() + "/rs/jbpm3/tokens/"+tok.getId()+"/transition?signal="+encodedSignal;
   }

   public String getAvailableActorsUrl(String actorId)
   {
      return getConsoleServerUrl() + "/rs/identity/user/"+actorId+"/actors";
   }

   public String getProcessDefinitionByNameURL(String name)
   {
      return getConsoleServerUrl() + "/rs/process/definitions/"+name;
   }

   public String getDeployTestHarnessUrl()
   {
      return getConsoleServerUrl()+ "/rs/test/deploy/harness";
   }

   public String getUndeployTestHarnessUrl()
   {
      return getConsoleServerUrl()+ "/rs/test/undeploy/harness";
   }

   public String getOverviewReportUrl()
   {
      String name = URL.encode(config.getOverviewReportFile());
      String url = config.getReportServerUrl() + "/rs/report/view/" + name;
      if(!GWT.isScript())
         url += "?id=birt";
      return url;
   }

   public String getDefinitionReportUrl(String name)
   {
      String reportName = URL.encode(name);
      String reportFileName = URL.encode(config.getDefinitionReportFile());
      String url = config.getReportServerUrl() + "/rs/report/view/" + reportFileName + "?name=" + reportName;
      if(!GWT.isScript())
         url += "&id=birt";
      return url;
   }
}
