/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import org.jboss.bpm.console.client.Editor;

/**
 * Maintains {@link org.jboss.bpm.console.client.Workspace}'s
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Workspace extends TabPanel
{
   protected MainView view;

   public Workspace()
   {
      super();

      this.setResizeTabs(true);
      this.setMinTabWidth(115);
      this.setTabWidth(135);
      this.setEnableTabScroll(true);
      this.setAutoScroll(true);      
      this.setActiveTab(0);      
   }

   private Panel addTab(Editor editor, boolean closeable) {
      Panel tab = new WrapperPanel(editor.getId()+".tab");
      tab.setAutoScroll(true);
      tab.setTitle(editor.getTitle());
      tab.setClosable(closeable);
      tab.setBorder(false);
      tab.setFrame(false);
      tab.setHideBorders(true);
      tab.setIconCls(editor.getIconCSS());
      this.add(tab);
      return tab;
   }

   public void addEditor(Editor editor, boolean closeable)
   {
      Panel tab = addTab(editor, closeable);
      tab.add(editor);
      this.setActiveTab(tab.getId());
   }

   public boolean hasEditor(String id)
   {
      boolean b = false;
      final String tabId = id +".tab";

      Component[] tabs = this.getItems();
      for(int i=0; i<tabs.length; i++)
      {
         Component tab = tabs[i];
         if(tab.getId().equals(tabId))
         {
            b=true;
            break;
         }
      }

      return b;
   }     

   public void showTab(String id)
   {
      final String tabId = id+".tab";
      this.setActiveTab(tabId);   
   }

   class WrapperPanel extends Panel
   {

      public WrapperPanel(String id)
      {
         super();
         setId(id);
      }
   }
}
