/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.json.client.*;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.model.forms.FieldDef;
import org.jboss.bpm.console.client.model.forms.FormDef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;
import org.jboss.bpm.console.client.util.JSONWalk;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * TODO: run integrated (gwt-console-server) test
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class DTOParser
{
   public static ProcessDefinitionRef parseProcessDefinition(String json)
   {
      JSONValue root = JSONParser.parse(json);
      long id = JSONWalk.on(root).next("processId").asLong();
      String version = JSONWalk.on(root).next("version").asString();
      String name = JSONWalk.on(root).next("name").asString();

      return new ProcessDefinitionRef(id, name, version);
   }
   public static List<String> parseRolesAssigned(String json)
   {
      // parse roles
      List<String> roles = new ArrayList<String>();

      // {"roles":[{"isAssigned":true,"role":"admin"},{"isAssigned":true,"role":"user"}]}

      JSONValue root = JSONParser.parse(json);
      JSONArray array = JSONWalk.on(root).next("roles").asArray();

      for (int i = 0; i < array.size(); ++i)
      {
         JSONObject item = array.get(i).isObject();
         boolean assigned = JSONWalk.on(item).next("assigned").asBool();
         String roleName = JSONWalk.on(item).next("role").asString();

         if(assigned)
         {
            roles.add(roleName);
         }
      }

      return roles;
   }

   public static List<TaskRef> parseTaskReferenceList(String json)
   {
      List<TaskRef> results = new ArrayList<TaskRef>();

      // {"tasks":[{"id":14,"name":"manager evaluation","isSignalling":true,
      // "isBlocking":false,"tokenId":6,"processInstanceId":4,"actor":"manager",
      // "transitionNames":["reject","approve"]}]}

      JSONValue root = JSONParser.parse(json);
      JSONArray array = JSONWalk.on(root).next("tasks").asArray();

      for (int i = 0; i < array.size(); ++i)
      {
         JSONObject item = array.get(i).isObject();
         TaskRef ref = parseTaskReference(item);
         results.add(ref);
      }

      return results;
   }

   public static TaskRef parseTaskReference(JSONObject item)
   {
      
      long id = JSONWalk.on(item).next("id").asLong();
      long tokenId = JSONWalk.on(item).next("tokenId").asLong();
      long instanceId = JSONWalk.on(item).next("processInstanceId").asLong();
      long processId = JSONWalk.on(item).next("processId").asLong();
      String name = JSONWalk.on(item).next("name").asString();
      String actor = JSONWalk.on(item).next("actor").asString();
      boolean isBlocking = JSONWalk.on(item).next("isBlocking").asBool();
      boolean isSignalling = JSONWalk.on(item).next("isSignalling").asBool();

      TaskRef ref = new TaskRef(
            id, tokenId, instanceId,
            processId,
            name, actor,
            isSignalling, isBlocking
      );


      // pooled actors
      JSONArray pooledActors = JSONWalk.on(item).next("pooledActors").asArray();
      for (int k = 0; k < pooledActors.size(); ++k)
      {
         JSONValue jsonValue = pooledActors.get(k);
         JSONString t = jsonValue.isString();
         ref.addPooledActor(t.stringValue());
      }

      if(isSignalling)
      {
         JSONArray arr = JSONWalk.on(item).next("transitionNames").asArray();
         for (int k = 0; k < arr.size(); ++k)
         {
            JSONValue jsonValue = arr.get(k);
            if(jsonValue.toString().equals("null"))
            {
               ConsoleLog.debug("FIXME JBPM-1828: Null value on transitionNames:" +arr.toString());
               continue; // TODO: JBPM-1828
            }
            JSONString t = jsonValue.isString();
            ref.getTransitionNames().add(t.stringValue());
         }

      }

      return ref;
   }

   public static Map<String,String> parseFormMapping(String json)
   {
      //[{"name":"update erp","value":"form.raise.erp-update.xhtml"}]

      throw new RuntimeException("Not implemented");

   }

   public static FormDef parseFormDef(String json)
   {
      return parseFormDef(JSONParser.parse(json));
   }

   public static FormDef parseFormDef(JSONValue root)
   {
      // {"formName":"taskform-15",
      // "fields":[
      //    {"varname":"amount","label":"FirstName","required":true,"inputType":"TEXT",
      //    "dataTypeClass":"java.lang.String","defaults":[]}
      // ]}

      String formName = JSONWalk.on(root).next("formName").asString();
      FormDef formDef = new FormDef(formName);

      JSONArray array = JSONWalk.on(root).next("fields").asArray();
      for(int i=0; i<array.size(); i++)
      {
         JSONObject item = array.get(i).isObject();

         // fieldDefs
         String label = JSONWalk.on(item).next("label").asString();
         String varName = JSONWalk.on(item).next("varname").asString();
         boolean required = JSONWalk.on(item).next("required").asBool();
         FieldDef.InputType inputType = FieldDef.InputType.valueOf(
               JSONWalk.on(item).next("inputType").asString()
         );

         String dataType = JSONWalk.on(item).next("dataTypeClass").asString();

         // TODO: Parse defaults

         formDef.getFields().add(
               new FieldDef(label, varName, inputType, dataType,required)
         );
      }

      return formDef;
   }

   public static ProcessInstanceRef parseProcessInstance(JSONObject root)
   {
      ConsoleLog.debug("parse " + root);

      long id = JSONWalk.on(root).next("instanceId").asLong();
      long parentId = JSONWalk.on(root).next("parentId").asLong();
      Date start = JSONWalk.on(root).next("startDate").asDate();

      JSONWalk.JSONWrapper endDateJSON = JSONWalk.on(root).next("endDate");
      Date end = null;
      if(endDateJSON!=null)
         end = endDateJSON.asDate();

      boolean suspended = JSONWalk.on(root).next("suspended").asBool();

      ProcessInstanceRef processInstance = new ProcessInstanceRef(
            id, parentId,
            start, end,
            suspended
      );

      // tokens
      JSONObject tokJso = JSONWalk.on(root).next("rootToken").asObject();
      TokenReference rootToken = parseTokenReference(tokJso);
      processInstance.setRootToken(rootToken);
      return processInstance;
   }

   public static TokenReference parseTokenReference(JSONObject jso)
   {
      long rootTokenId = JSONWalk.on(jso).next("id").asLong();
      String name = JSONWalk.on(jso).next("name").asString();
      String nodeName = JSONWalk.on(jso).next("currentNodeName").asString();

      TokenReference rt = new TokenReference(rootTokenId, name, nodeName);

      boolean canBeSignaled = JSONWalk.on(jso).next("canBeSignaled").asBool();
      rt.setCanBeSignaled(canBeSignaled);
      
      JSONArray signals = JSONWalk.on(jso).next("availableSignals").asArray();
      for(int i=0; i<signals.size(); i++)
      {
         JSONValue jsonValue = signals.get(i);
         if(jsonValue.toString().equals("null"))
         {
            ConsoleLog.debug("FIXME JBPM-1828: Null value on availableSignals:" +signals.toString());
            continue; // TODO: JBPM-1828
         }
         JSONString item = jsonValue.isString();
         rt.getAvailableSignals().add(item.stringValue());
      }

      JSONArray childArr = JSONWalk.on(jso).next("children").asArray();
      for(int i=0; i<childArr.size(); i++)
      {
         JSONObject item = childArr.get(i).isObject();
         rt.getChildren().add(parseTokenReference(item));   
      }

      return rt;
   }

   public static List<String> parseStringArray(JSONValue jso)
   {
      List<String> result = new ArrayList<String>();

      JSONArray jsonArray = jso.isArray();

      if(null==jsonArray)
         throw new IllegalArgumentException("Not an array: " +jso);
      
      for(int i=0; i<jsonArray.size(); i++)
      {
         JSONValue jsonValue = jsonArray.get(i);
         if(jsonValue.toString().equals("null"))
         {
            ConsoleLog.debug("FIXME JBPM-1828: Null value on string array:" +jsonArray.toString());
            continue; // TODO: JBPM-1828
         }
         JSONString item = jsonValue.isString();
         result.add(item.stringValue());
      }

      return result;
   }
}
