/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.gwtext.client.core.Connection;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.FormListenerAdapter;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.widgets.HelpPanel;
import org.jboss.bpm.console.client.util.ModelListenerRegistry;
import org.jboss.bpm.console.client.util.ModelModificationCallback;
import org.jboss.bpm.console.client.widgets.TeaserPanel;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ProcessDefinitionListEditor extends Editor
{
   public final static String ID = "org.jboss.bpm.process.ProcessDefinitionListEditor";

   private ProcessDefinitionList processDefinitionList;
   private MainView view;
   private Panel teaserPanel;
   private ModelListenerRegistry modelListeners = new ModelListenerRegistry();

   public ProcessDefinitionListEditor(final MainView view)
   {
      super();
      this.setId(ID);

      this.view = view;

      this.setLayout( new ColumnLayout() );
      this.setWidth(UIConstants.EDITOR_WIDTH);

      // ----------------------------------

      final Panel leftHand = new Panel();
      leftHand.setFrame(false);
      leftHand.setHeader(false);
      leftHand.setBorder(false);

      // ----------------------------------
            
      final ModelModificationCallback modelModificationCallback = new ModelModificationCallback()
      {
         public void onStaleModel()
         {
            resetEditor();
         }
      };

      // ----------------------------------

      processDefinitionList = new ProcessDefinitionList(
            modelModificationCallback, "Process Definitions", view
      );

      // ----------------------------------

      Panel outerFormPanel = new Panel();
      outerFormPanel.setBorder(false);
      outerFormPanel.setPaddings(10);
      

      final FormPanel formPanel = new FormPanel();
      formPanel.setFrame(true);
      formPanel.setTitle("Upload new process definition");
      formPanel.setLabelWidth(75);
      formPanel.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
     
      formPanel.setFileUpload(true);
      final TextField file = new TextField("File", "file");
      file.setInputType("file");      
      
      formPanel.add(file);

      Button uploadButton = new Button("Upload", new ButtonListenerAdapter()
      {
         public void onClick(Button button, EventObject e)
         {
            formPanel.getForm().submit(
              view.getUrlBuilder().getUploadDefinitionURL(), null,
              Connection.POST, "Uploading definition ...", false);
         }
      });      
      formPanel.addButton(uploadButton);
      
      formPanel.getForm().addListener(
        new FormListenerAdapter()
        {

           public boolean doBeforeAction(Form form)
           {
              if(!GWT.isScript())
              {
                 MessageBox.alert("Uploads only work on web mode!");
                 return false;
              }
              else if(form.findField("file").getValueAsString().equals(""))
              {
                 MessageBox.alert("Please provide a process definition file");
                 return false;
              }

              
              return true;
           }

           public void onActionComplete(Form form, int i, String string)
           {
              processDefinitionList.reloadStore();
              leftHand.doLayout();
              form.reset();
           }

           public void onActionFailed(Form form, int i, String string)
           {
              super.onActionFailed(form, i, string);
              ConsoleLog.error("Failed to upload process definition: " + string );
           }
        }
      );

      outerFormPanel.add(formPanel);

      // ----------------------------------

      //HelpPanel help = new HelpPanel(UIConstants.TEASER_PANEL_WIDTH, 180, "About process definitions");
      //help.setContent( "");

      // ----------------------------------

      teaserPanel = new TeaserPanel();
      //teaserPanel.add(help);

      // ----------------------------------

      leftHand.add(processDefinitionList);
      leftHand.add(outerFormPanel);            

      // ----------------------------------

      this.add(leftHand, new ColumnLayoutData(0.7) );
      this.add(teaserPanel , new ColumnLayoutData(0.3) );

   }


   public String getEditorId()
   {
      return ID;
   }

   public String getTitle()
   {
      return "Processes";
   }

   public String getIconCSS()
   {
      return "bpm-process-icon";
   }

   public ProcessDefinitionList getProcessDefinitionList()
   {
      return processDefinitionList;
   }

   public void resetEditor()
   {
      processDefinitionList.reloadStore();
      modelListeners.fireResetEvent();
   }
}
