/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.gwtext.client.widgets.*;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.core.EventObject;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.widgets.TeaserPanel;
import org.jboss.bpm.console.client.widgets.HelpPanel;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 *
 * @see ProcessInstanceList#onExamine(int) 
 */
public class ProcessInstanceEditor extends Editor
{
   public final static String ID = "org.jboss.bpm.process.ProcessInstance";

   private ProcessDefinitionRef processDefinition;

   private ProcessInstanceRef processInstance;

   private MainView view;

   private Panel teaserPanel;

   public ProcessInstanceEditor(final ProcessDefinitionRef proc, final ProcessInstanceRef instance, final MainView view)
   {
      super();
      this.setId(ProcessInstanceEditor.ID+"."+instance.getInstanceId());

      this.processDefinition = proc;
      this.processInstance = instance;
      this.view = view;

      // ----------------------------------

      this.setPaddings(10);
      this.setWidth(UIConstants.EDITOR_WIDTH);
      this.setLayout( new ColumnLayout() );

      this.setBorder(false);
      this.setHeader(false);

      // ----------------------------------

      ProcessImageView imageView = new ProcessImageView(instance, view);
      imageView.setWidth(UIConstants.EDITOR_PANEL_WIDTH);

      Toolbar imageToolbar = new Toolbar();
      imageToolbar.addFill();
      ToolbarButton toolbarButton = new ToolbarButton("Enlarge",
        new ButtonListenerAdapter()
        {
           public void onClick(Button button, EventObject e)
           {

              final Window window = new Window();
              window.setTitle("Process Graph");
              window.setClosable(true);
              window.setWidth(800);
              window.setHeight(600);
              window.setPlain(true);              
              window.setCloseAction(Window.HIDE);
              window.add(new ProcessImageView(instance, view) );
              window.show("");
           }
        }
      );
      toolbarButton.setIconCls("bpm-enlarge-icon");
      imageToolbar.addButton( toolbarButton );
      imageView.setBottomToolbar(imageToolbar);
      
      PaddedPanel rightPanel = new PaddedPanel(imageView, 5, 5, 0, 5);

      // ----------------------------------

      teaserPanel = new TeaserPanel();

      // ----------------------------------

      HelpPanel taskPanel = new HelpPanel(200, 180, "Associated Tasks");
      taskPanel.setIconCls("bpm-task-icon");
      taskPanel.setContent("Process instances can have user tasks associated with them. " +
        "These tasks will cross referenced here.");

      Toolbar bottomToolbar = new Toolbar();
      bottomToolbar.addFill();
      ToolbarButton taskBtn = new ToolbarButton("View tasks",
        new ButtonListenerAdapter()
        {
           public void onClick(Button button, EventObject e)
           {
           }
        }
      );
      taskBtn.setIconCls("bpm-switch-context-icon");
      bottomToolbar.addButton(taskBtn);

      taskPanel.setBottomToolbar(bottomToolbar);
      teaserPanel.add(taskPanel);

      // ----------------------------------

      HelpPanel commentPanel = new HelpPanel(200, 180, "Leave a comment");
      commentPanel.setIconCls("bpm-comment-icon");
      commentPanel.setContent("Users can leave comments about processes and process instances" +
        " in particular. This teaser will launch the comment form/list view");

      Toolbar bottomToolbar2 = new Toolbar();
      bottomToolbar2.addFill();
      bottomToolbar2.addButton(
        new ToolbarButton("View/Add comments", new ButtonListenerAdapter()
        {
           public void onClick(Button button, EventObject e)
           {
           }
        })
      );

      commentPanel.setBottomToolbar(bottomToolbar2);
      teaserPanel.add(commentPanel);

      // ----------------------------------

      this.add(rightPanel, new ColumnLayoutData(0.7) );
      this.add(teaserPanel, new ColumnLayoutData(0.3) );
   }

   public String getEditorId()
   {
      return ID;
   }

   public String getTitle()
   {
      return "#"+processInstance.getInstanceId()+" ("+processDefinition.getName()+")";
   }


   public String getIconCSS()
   {
      return "bpm-instance-icon";
   }

   public static String createWidgetID(ProcessDefinitionRef parent)
   {
      return ProcessInstanceEditor.ID+"."+parent.getName()+"."+parent.getVersion();
   }
}
