/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.widgets.RefreshableComboBox;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class TokenForm extends Panel
{
   private final FormPanel tokenForm;
   private final Button signalButton;
   private TokenReference lastSelectedToken;
   
   public TokenForm(final TokenEditor.SignalCallback callback)
   {
      super();

      this.setHeader(false);
      this.setBorder(false);
      this.setFrame(false);

      tokenForm = new FormPanel();
      tokenForm.setLabelAlign(Position.LEFT);
      tokenForm.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
      tokenForm.setHeader(false);
      tokenForm.setFrame(false);
      tokenForm.setBorder(false);
      tokenForm.setPaddings(5, 5, 5, 0);
      tokenForm.setLabelWidth(50);

      // ----------

      TextField idField = new TextField("Id", "id", 230);
      idField.setReadOnly(true);
      tokenForm.add(idField);

      //tokenForm.add(new TextField("Token Name", "name", 230));
      TextField nameField = new TextField("Node Name", "nodeName", 230);
      nameField.setReadOnly(true);
      tokenForm.add(nameField);


      // ----------
      RefreshableComboBox cb = new RefreshableComboBox("signal", "Signal");
      tokenForm.add(cb);

      final ButtonListenerAdapter listenerAdapter = new ButtonListenerAdapter()
      {
         public void onClick(Button button, EventObject eventObject)
         {
            ComboBox cb = (ComboBox)tokenForm.getForm().findField("signal");
                        
            String signalValue = cb.getValueAsString();
            if(signalValue.equals(""))
               MessageBox.alert("Please select a signal");
            else
               callback.onSignalToken(lastSelectedToken, signalValue);
         }

      };
      signalButton = new Button("Signal", listenerAdapter);


      tokenForm.addButton(signalButton);

      // -------------------

      this.add(tokenForm);

   }

   /**
    * display the root token
    */
   void display(ProcessInstanceRef processInstance)
   {
      display(processInstance, processInstance.getRootToken());
   }

   /**
    * display a particular token
    */
   void display(final ProcessInstanceRef processInstance, final TokenReference tok)
   {
      Form form = tokenForm.getForm();

      if(form.findField("id")!=null) // TODO: the fields are not initialized on first callback?
      {
         form.findField("id").setRawValue(tok.getId()+"");
         form.findField("nodeName").setRawValue(tok.getCurrentNodeName());

         // display combo box
         RefreshableComboBox cb = (RefreshableComboBox)form.findField("signal");
         cb.reset();
         cb.display( tok.getAvailableSignals());
         
         // suspended instances cannot be signaled
         if(processInstance.isSuspended() || !tok.canBeSignaled())
         {
            signalButton.disable();
            cb.disable();
         }
         else
         {
            signalButton.enable();
            cb.enable();
         }
      }

      // -----------


      lastSelectedToken = tok;
   }
   
   public void resetForm()
   {      
      tokenForm.getForm().reset();
   }
}
