/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.*;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.event.PanelListenerAdapter;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.widgets.layout.HorizontalLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;
import com.gwtext.client.widgets.menu.Separator;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.util.ConsoleLog;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class OverviewReportEditor extends Editor
{
   public final static String ID = "org.jboss.bpm.metric.ProcessMetricOverview";
   private MainView view;

   public OverviewReportEditor(final MainView view)
   {
      super();
      this.view = view;
      this.setId(ID);
      this.setPaddings(10);

      // -------------------------------------
      this.setLayout(new VerticalLayout(10) );

      this.addListener(
            new PanelListenerAdapter()
            {
               public void onRender(Component component)
               {
                  Panel panel = new Panel("Metric overview");
                  panel.setPaddings(10);

                  final String reportUrl= view.getUrlBuilder().getOverviewReportUrl();
                  ConsoleLog.debug("Report resource:" + reportUrl);

                  final ComboBox comboBox = buildProcessSelection();

                  final BirtPanel birtPanel = new BirtPanel();
                  birtPanel.setUrl(reportUrl);

                  // --

                  Button refreshBtn = new Button("Refresh", new ButtonListenerAdapter()
                  {

                     public void onClick(Button button, EventObject eventObject)
                     {
                        birtPanel.setUrl(reportUrl);
                     }
                  });

                  Button viewBtn = new Button("Examine", new ButtonListenerAdapter()
                  {

                     public void onClick(Button button, EventObject eventObject)
                     {
                        String rawValue = comboBox.getRawValue();
                        if(rawValue==null || rawValue.equals(""))
                           MessageBox.alert("Please enter a process definition name!");
                        else
                           onExamine(rawValue);
                     }
                  });

                  // --

                  Panel toolsPanel  = new Panel();
                  toolsPanel.setLayout( new HorizontalLayout(10) );
                  Label label = new Label("Process definition");
                  label.setStyleName("bpm-label");
                  toolsPanel.add(label);
                  toolsPanel.add(comboBox);
                  toolsPanel.add( viewBtn );
                  toolsPanel.add( new Separator() );
                  toolsPanel.add( refreshBtn );

                  panel.add(toolsPanel);
                  panel.add(birtPanel);

                  add(panel);
               }
            }
      );
   }


   private void onExamine(String definitionName)
   {
      String editorId = ProcessReportEditor.createWidgetID(definitionName);

      if(view.hasEditor(editorId))
         view.showEditor(editorId);
      else
         view.addEditor( new ProcessReportEditor(definitionName, view) );
   }

   private ComboBox buildProcessSelection()
   {

      final RecordDef recordDef = new RecordDef(
        new FieldDef[]{
          new IntegerFieldDef("processId"),
          new StringFieldDef("name"),
          new StringFieldDef("version")
        }
      );

      final JsonReader reader = new JsonReader(recordDef);
      reader.setRoot("definitions");
      reader.setTotalProperty("totalCount");
      reader.setId("processId");

      DataProxy dataProxy = new ScriptTagProxy(
            view.getUrlBuilder().getProcessDefinitionsURL(), 1000*10);

      final Store store = new Store(dataProxy, reader, false);
      store.load();

      ComboBox cb = new ComboBox();
      cb.setMinChars(1);
      cb.setFieldLabel("Process definition");
      cb.setStore(store);
      cb.setDisplayField("name");
      cb.setMode(ComboBox.LOCAL);
      cb.setTriggerAction(ComboBox.ALL);
      cb.setEmptyText("Please enter a name");
      cb.setLoadingText("Searching...");
      cb.setTypeAhead(true);
      cb.setSelectOnFocus(true);
      cb.setWidth(180);

      return cb;
   }

   public String getEditorId()
   {
      return ID;
   }

   public String getTitle()
   {
      return "Metrics and Stats";
   }

   public String getIconCSS()
   {
      return "bpm-report-icon";
   }
}
