/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.UIConstants;
import org.jboss.bpm.console.client.util.ConsoleLog;
import com.gwtext.client.widgets.layout.VerticalLayout;
import com.gwtext.client.widgets.layout.HorizontalLayout;
import com.gwtext.client.widgets.event.PanelListenerAdapter;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.menu.Separator;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.*;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ProcessReportEditor extends Editor
{
   public final static String ID = "org.jboss.bpm.metric.ProcessMetric";
   private String definitionName;
   private MainView view;

   public ProcessReportEditor(final String definitionName, final MainView view)
   {
      this.definitionName = definitionName;
      this.view = view;
      this.setId( createWidgetID(definitionName) );

      this.setPaddings(10);

      // -------------------------------------
      this.setLayout(new VerticalLayout(10) );

      this.addListener(
            new PanelListenerAdapter()
            {

               public void onRender(Component component)
               {

                  final String reportUrl= view.getUrlBuilder().getDefinitionReportUrl(definitionName);
                  ConsoleLog.debug("Report resource:" + reportUrl);

                  final ComboBox comboBox = buildInstanceSelection();

                  final BirtPanel birtPanel = new BirtPanel();
                  birtPanel.setUrl(reportUrl);

                  // --

                  Button refreshBtn = new Button("Refresh", new ButtonListenerAdapter()
                  {

                     public void onClick(Button button, EventObject eventObject)
                     {
                        birtPanel.setUrl(reportUrl);
                     }
                  });

                  Button viewBtn = new Button("Examine", new ButtonListenerAdapter()
                  {

                     public void onClick(Button button, EventObject eventObject)
                     {
                        String rawValue = comboBox.getRawValue();
                        if(rawValue==null || rawValue.equals(""))
                           MessageBox.alert("Please enter a process instance ID!");
                        else
                           MessageBox.alert("Not implemented");
                     }
                  });

                  // --

                  Panel p  = new Panel();
                  p.setLayout( new HorizontalLayout(10) );
                  Label label = new Label("Instance ID");
                  label.setStyleName("bpm-label");
                  p.add(label);
                  p.add(comboBox);
                  p.add( viewBtn );
                  p.add( new Separator() );
                  p.add( refreshBtn );

                  add(p);
                  add(birtPanel);
               }
            }
      );
   }

   private ComboBox buildInstanceSelection()
   {

      final RecordDef recordDef = new RecordDef(
            new FieldDef[]{
                  new IntegerFieldDef("instanceId"),
                  new IntegerFieldDef("parentId"),
                  new StringFieldDef("key"),
                  new StringFieldDef("state"),
                  new DateFieldDef("startDate", UIConstants.DATE_FORMAT),
                  new DateFieldDef("endDate", UIConstants.DATE_FORMAT),
                  new BooleanFieldDef("suspended")
            }
      );

      final JsonReader reader = new JsonReader(recordDef);
      reader.setRoot("instances");
      reader.setTotalProperty("totalCount");
      reader.setId("instanceId");

      DataProxy dataProxy = new ScriptTagProxy(
            view.getUrlBuilder().getProcessDefinitionsURL(), 1000*10);

      final Store store = new Store(dataProxy, reader, false);
      store.load();

      ComboBox cb = new ComboBox();
      cb.setMinChars(1);
      cb.setFieldLabel("Instance ID");
      cb.setStore(store);
      cb.setDisplayField("ID");
      cb.setMode(ComboBox.LOCAL);
      cb.setTriggerAction(ComboBox.ALL);
      cb.setEmptyText("Please enter an ID");
      cb.setLoadingText("Searching...");
      cb.setTypeAhead(true);
      cb.setSelectOnFocus(true);
      cb.setWidth(180);

      return cb;
   }
   public String getEditorId()
   {
      return createWidgetID(definitionName);
   }

   public String getTitle()
   {
      return definitionName +" Metrics";
   }

   public String getIconCSS()
   {
      return "bpm-report-icon";
   }

   public static String createWidgetID(String definitionName)
   {
      return ID+"."+definitionName;
   }
}
