/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.widgets;

import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.form.FormPanel;
import org.jboss.bpm.console.client.UIConstants;

/**
 * Helps construction common form elements.
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class FormWidgets
{
   public static FormPanel createBaseFormPanel()
   {
      final FormPanel formPanel = new FormPanel();
      formPanel.setLabelAlign(Position.LEFT);
      formPanel.setWidth(UIConstants.EDITOR_PANEL_WIDTH);
      formPanel.setHeader(false);
      formPanel.setFrame(false);
      formPanel.setBorder(false);
      formPanel.setPaddings(5, 5, 5, 0);
      formPanel.setLabelWidth(120);
      return formPanel;
   }

   
}
