/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.widgets;

import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.data.*;

import java.util.ArrayList;
import java.util.List;

import org.jboss.bpm.console.client.UIConstants;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class RefreshableComboBox extends ComboBox
{

   private final Reader reader;

   public RefreshableComboBox(String fieldName, String label)
   {
      super();
      this.reader = new ArrayReader(new RecordDef(
            new FieldDef[]{
                  new StringFieldDef(fieldName)
            }
      ));

      MemoryProxy dataProxy = createMemoryProxy(new ArrayList<String>());
      Store store = new Store(dataProxy, reader);
      store.load();

      setFieldLabel(label);
      setHiddenName(fieldName);
      setStore(store);
      setDisplayField(fieldName);
      setMode(ComboBox.LOCAL);
      setTriggerAction(ComboBox.ALL);
      setEmptyText("");
      setSelectOnFocus(true);
      setWidth(190);
      setEditable(false);
   }

   private MemoryProxy createMemoryProxy(List<String> items)
   {
      if(items.isEmpty())
         items.add(UIConstants.DEFAULT_TRANSITION);

      Object[][] objs = new Object[items.size()][];
      int i=0;
      for(String s : items)
      {
         objs[i] = new Object[]{s};
         i++;
      }

      return new MemoryProxy(objs);
   }

   public void display(List<String> items)
   {
      super.reset();
      
      MemoryProxy dataProxy = createMemoryProxy(items);
      Store store = new Store(dataProxy, reader);
      store.load();
      super.setStore(store);
   }
}