/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Preconditions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DisjunctionExclusionStrategy
implements ExclusionStrategy {
    private final Collection<ExclusionStrategy> strategies;

    public DisjunctionExclusionStrategy(ExclusionStrategy ... strategies) {
        Preconditions.checkNotNull((Object)strategies);
        Preconditions.checkArgument((strategies.length > 0 ? 1 : 0) != 0);
        this.strategies = new LinkedList();
        for (ExclusionStrategy strategy : strategies) {
            this.strategies.add(strategy);
        }
    }

    public DisjunctionExclusionStrategy(Collection<ExclusionStrategy> strategies) {
        Preconditions.checkNotNull(strategies);
        Preconditions.checkArgument((!strategies.isEmpty() ? 1 : 0) != 0);
        this.strategies = new LinkedList();
        this.strategies.addAll(strategies);
    }

    public boolean shouldSkipField(Field f) {
        for (ExclusionStrategy strategy : this.strategies) {
            if (!strategy.shouldSkipField(f)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        for (ExclusionStrategy strategy : this.strategies) {
            if (!strategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }
}

