/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModifierBasedExclusionStrategy
implements ExclusionStrategy {
    private final boolean skipSyntheticField;
    private final Collection<Integer> modifiers;

    public ModifierBasedExclusionStrategy(boolean skipSyntheticFields, int ... modifiers) {
        this.skipSyntheticField = skipSyntheticFields;
        this.modifiers = new HashSet();
        if (modifiers != null) {
            for (int modifier : modifiers) {
                this.modifiers.add(modifier);
            }
        }
    }

    public boolean shouldSkipField(Field f) {
        if (this.skipSyntheticField && f.isSynthetic()) {
            return true;
        }
        int objectModifiers = f.getModifiers();
        Iterator i$ = this.modifiers.iterator();
        while (i$.hasNext()) {
            int modifier = (Integer)i$.next();
            if ((objectModifiers & modifier) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }
}

