/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Gson;
import com.google.gson.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParameterizedTypeHandlerMap<T> {
    private final Map<Type, T> map = new HashMap();
    private boolean modifiable = true;

    ParameterizedTypeHandlerMap() {
    }

    public synchronized void register(Type typeOfT, T value) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        if (this.hasSpecificHandlerFor(typeOfT)) {
            Gson.logger.log(Level.WARNING, "Overriding the existing type handler for " + typeOfT);
        }
        this.map.put(typeOfT, value);
    }

    public synchronized void registerIfAbsent(ParameterizedTypeHandlerMap<T> other) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        for (Map.Entry entry : other.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            this.register((Type)entry.getKey(), entry.getValue());
        }
    }

    public synchronized void makeUnmodifiable() {
        this.modifiable = false;
    }

    public synchronized T getHandlerFor(Type type) {
        Object handler = this.map.get(type);
        if (handler == null && type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            handler = this.map.get(rawType);
        }
        return (T)handler;
    }

    public synchronized boolean hasAnyHandlerFor(Type type) {
        return this.getHandlerFor(type) != null;
    }

    public synchronized boolean hasSpecificHandlerFor(Type type) {
        return this.map.containsKey(type);
    }

    public synchronized ParameterizedTypeHandlerMap<T> copyOf() {
        ParameterizedTypeHandlerMap copy = new ParameterizedTypeHandlerMap();
        for (Map.Entry entry : this.map.entrySet()) {
            copy.register((Type)entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public synchronized Set<Map.Entry<Type, T>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.typeToString((Type)entry.getKey())).append(':');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private String typeToString(Type type) {
        return TypeUtils.toRawClass((Type)type).getSimpleName();
    }
}

