/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;

/*
 * Exception performing whole class analysis ignored.
 */
class ContextFinder {
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.bind.v2.ContextFactory";

    ContextFinder() {
    }

    private static void handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        Throwable t = x.getTargetException();
        if (t != null) {
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
    }

    private static void handleClassCastException(Class originalType, Class targetType) throws JAXBException {
        URL targetTypeURL = ContextFinder.which((Class)targetType);
        throw new JAXBException(Messages.format((String)"JAXBContext.IllegalCast", (Object)originalType.getClass().getClassLoader().getResource("javax/xml/bind/JAXBContext.class").toString(), (Object)targetTypeURL.toString()));
    }

    static JAXBContext newInstance(String contextPath, String className, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            Method m;
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            Object context = null;
            try {
                m = spiClass.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                context = m.invoke(null, contextPath, classLoader, properties);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (context == null) {
                m = spiClass.getMethod("createContext", String.class, ClassLoader.class);
                context = m.invoke(null, contextPath, classLoader);
            }
            if (!(context instanceof JAXBContext)) {
                ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format((String)"ContextFinder.ProviderNotFound", (Object)className), (Throwable)x);
        }
        catch (InvocationTargetException x) {
            ContextFinder.handleInvocationTargetException((InvocationTargetException)x);
            Throwable e = x;
            if (x.getTargetException() != null) {
                e = x.getTargetException();
            }
            throw new JAXBException(Messages.format((String)"ContextFinder.CouldNotInstantiate", (Object)className, (Object)e), e);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format((String)"ContextFinder.CouldNotInstantiate", (Object)className, (Object)x), (Throwable)x);
        }
    }

    static JAXBContext newInstance(Class[] classes, Map properties, String className) throws JAXBException {
        Method m;
        Class<?> spi;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            logger.fine("Trying to load " + className);
            spi = cl != null ? cl.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException((Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loaded " + className + " from " + ContextFinder.which(spi));
        }
        try {
            m = spi.getMethod("createContext", Class[].class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXBException((Throwable)e);
        }
        try {
            Object context = m.invoke(null, classes, properties);
            if (!(context instanceof JAXBContext)) {
                ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (IllegalAccessException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ContextFinder.handleInvocationTargetException((InvocationTargetException)e);
            Throwable x = e;
            if (e.getTargetException() != null) {
                x = e.getTargetException();
            }
            throw new JAXBException(x);
        }
    }

    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        String jaxbContextFQCN = JAXBContext.class.getName();
        StringTokenizer packages = new StringTokenizer(contextPath, ":");
        if (!packages.hasMoreTokens()) {
            throw new JAXBException(Messages.format((String)"ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (packages.hasMoreTokens()) {
            String packageName = packages.nextToken(":").replace('.', '/');
            StringBuilder propFileName = new StringBuilder().append(packageName).append("/jaxb.properties");
            Properties props = ContextFinder.loadJAXBProperties((ClassLoader)classLoader, (String)propFileName.toString());
            if (props == null) continue;
            if (props.containsKey(factoryId)) {
                String factoryClassName = props.getProperty(factoryId);
                return ContextFinder.newInstance((String)contextPath, (String)factoryClassName, (ClassLoader)classLoader, (Map)properties);
            }
            throw new JAXBException(Messages.format((String)"ContextFinder.MissingProperty", (Object)packageName, (Object)factoryId));
        }
        logger.fine("Searching the system property");
        String factoryClassName = System.getProperty(jaxbContextFQCN, null);
        if (factoryClassName != null) {
            return ContextFinder.newInstance((String)contextPath, (String)factoryClassName, (ClassLoader)classLoader, (Map)properties);
        }
        logger.fine("Searching META-INF/services");
        try {
            StringBuilder resource = new StringBuilder().append("META-INF/services/").append(jaxbContextFQCN);
            InputStream resourceStream = classLoader.getResourceAsStream(resource.toString());
            if (resourceStream != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                factoryClassName = r.readLine().trim();
                return ContextFinder.newInstance((String)contextPath, (String)factoryClassName, (ClassLoader)classLoader, (Map)properties);
            }
            logger.fine("Unable to load:" + resource.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((String)contextPath, (String)"com.sun.xml.bind.v2.ContextFactory", (ClassLoader)classLoader, (Map)properties);
    }

    static JAXBContext find(Class[] classes, Map properties) throws JAXBException {
        String jaxbContextFQCN = JAXBContext.class.getName();
        for (Class c : classes) {
            ClassLoader classLoader = c.getClassLoader();
            Package pkg = c.getPackage();
            if (pkg == null) continue;
            String packageName = pkg.getName().replace('.', '/');
            String resourceName = packageName + "/jaxb.properties";
            logger.fine("Trying to locate " + resourceName);
            Properties props = ContextFinder.loadJAXBProperties((ClassLoader)classLoader, (String)resourceName);
            if (props == null) {
                logger.fine("  not found");
                continue;
            }
            logger.fine("  found");
            if (props.containsKey("javax.xml.bind.context.factory")) {
                String factoryClassName = props.getProperty("javax.xml.bind.context.factory").trim();
                return ContextFinder.newInstance((Class[])classes, (Map)properties, (String)factoryClassName);
            }
            throw new JAXBException(Messages.format((String)"ContextFinder.MissingProperty", (Object)packageName, (Object)"javax.xml.bind.context.factory"));
        }
        logger.fine("Checking system property " + jaxbContextFQCN);
        String factoryClassName = System.getProperty(jaxbContextFQCN, null);
        if (factoryClassName != null) {
            logger.fine("  found " + factoryClassName);
            return ContextFinder.newInstance((Class[])classes, (Map)properties, (String)factoryClassName);
        }
        logger.fine("  not found");
        logger.fine("Checking META-INF/services");
        try {
            String resource = "META-INF/services/" + jaxbContextFQCN;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resourceURL = classLoader == null ? ClassLoader.getSystemResource(resource) : classLoader.getResource(resource);
            if (resourceURL != null) {
                logger.fine("Reading " + resourceURL);
                BufferedReader r = new BufferedReader(new InputStreamReader(resourceURL.openStream(), "UTF-8"));
                factoryClassName = r.readLine().trim();
                return ContextFinder.newInstance((Class[])classes, (Map)properties, (String)factoryClassName);
            }
            logger.fine("Unable to find: " + resource);
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((Class[])classes, (Map)properties, (String)"com.sun.xml.bind.v2.ContextFactory");
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String propFileName) throws JAXBException {
        Properties props = null;
        try {
            URL url = classLoader == null ? ClassLoader.getSystemResource(propFileName) : classLoader.getResource(propFileName);
            if (url != null) {
                logger.fine("loading props from " + url);
                props = new Properties();
                InputStream is = url.openStream();
                props.load(is);
                is.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Unable to load " + propFileName, ioe);
            throw new JAXBException(ioe.toString(), (Throwable)ioe);
        }
        return props;
    }

    static URL which(Class clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    static URL which(Class clazz) {
        return ContextFinder.which((Class)clazz, (ClassLoader)clazz.getClassLoader());
    }

    static {
        try {
            if (System.getProperty("jaxb.debug", null) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

