/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;

public class URLBuilder {
    ConsoleConfig config;

    public URLBuilder(ConsoleConfig config) {
        this.config = config;
    }

    public String getConsoleServerUrl() {
        return this.config.getConsoleServerUrl();
    }

    public String getProcessDefinitionsURL() {
        return this.getConsoleServerUrl() + "/rs/process/definitions";
    }

    public String getProcessInstancesURL(long processId) {
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + processId + "/instances";
    }

    public String getUserInRoleURL(String[] possibleRoles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < possibleRoles.length; ++i) {
            sb.append(URL.encode((String)possibleRoles[i]));
            if (i >= possibleRoles.length - 1) continue;
            sb.append(",");
        }
        return this.getConsoleServerUrl() + "/rs/identity/user/roles?roleCheck=" + sb.toString();
    }

    @Deprecated
    public String getRemoveDefinitionURL(long processId) {
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + processId + "/remove";
    }

    public String getProcessImageURL(long processId) {
        return this.getConsoleServerUrl() + "/rs/jbpm3/definitions/" + processId + "/image";
    }

    public String getDiagramInfoURL(long processId) {
        return this.getConsoleServerUrl() + "/rs/jbpm3/definitions/" + processId + "/diagramInfo";
    }

    public String getActiveNodeInfoURL(long instanceId) {
        return this.getConsoleServerUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
    }

    public String getStateChangeURL(long instanceId, ProcessInstanceRef.STATE state) {
        return this.getConsoleServerUrl() + "/rs/process/instances/" + instanceId + "/state/" + state;
    }

    public String getStartNewInstanceURL(long processId) {
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + processId + "/instances/new";
    }

    public String getUploadDefinitionURL() {
        return this.getConsoleServerUrl() + "/rs/jbpm3/definitions/new";
    }

    public String getTaskListByActorURL(String actor) {
        return this.getConsoleServerUrl() + "/rs/tasks/actor/" + URL.encode((String)actor);
    }

    public String getTaskFormDefURL(long processId, long taskId) {
        return this.getConsoleServerUrl() + "/rs/tasks/forms/" + processId + "/" + taskId;
    }

    public String getTaskEndURL(long id) {
        return this.getConsoleServerUrl() + "/rs/tasks/" + id + "/close/transition/default";
    }

    public String getTaskEndURL(long id, String signalName) {
        return this.getConsoleServerUrl() + "/rs/tasks/" + id + "/close/transition?signal=" + URL.encode((String)signalName);
    }

    public String getTaskAssignmentURL(long id, String actor) {
        String actualActor = actor == null ? "" : "/" + actor;
        return this.getConsoleServerUrl() + "/rs/tasks/" + id + "/assignment" + URL.encode((String)actualActor);
    }

    public String getTokenSignalUrl(TokenReference tok) {
        return this.getConsoleServerUrl() + "/rs/jbpm3/tokens/" + tok.getId() + "/transition/default";
    }

    public String getTokenSignalUrl(TokenReference tok, String signal) {
        String encodedSignal = URL.encode((String)signal);
        return this.getConsoleServerUrl() + "/rs/jbpm3/tokens/" + tok.getId() + "/transition?signal=" + encodedSignal;
    }

    public String getAvailableActorsUrl(String actorId) {
        return this.getConsoleServerUrl() + "/rs/identity/user/" + actorId + "/actors";
    }

    public String getProcessDefinitionByNameURL(String name) {
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + name;
    }

    public String getDeployTestHarnessUrl() {
        return this.getConsoleServerUrl() + "/rs/test/deploy/harness";
    }

    public String getUndeployTestHarnessUrl() {
        return this.getConsoleServerUrl() + "/rs/test/undeploy/harness";
    }

    public String getOverviewReportUrl() {
        String name = URL.encode((String)this.config.getOverviewReportFile());
        String url = this.config.getReportServerUrl() + "/rs/report/view/" + name;
        if (!GWT.isScript()) {
            url = url + "?id=birt";
        }
        return url;
    }

    public String getDefinitionReportUrl(String name) {
        String reportName = URL.encode((String)name);
        String reportFileName = URL.encode((String)this.config.getDefinitionReportFile());
        String url = this.config.getReportServerUrl() + "/rs/report/view/" + reportFileName + "?name=" + reportName;
        if (!GWT.isScript()) {
            url = url + "&id=birt";
        }
        return url;
    }
}

