/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.forms.FieldDef;
import org.jboss.bpm.console.client.model.forms.FormDef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DTOParser {
    public static ProcessDefinitionRef parseProcessDefinition(String json) {
        JSONValue root = JSONParser.parse((String)json);
        long id = JSONWalk.on((JSONValue)root).next("processId").asLong();
        String version = JSONWalk.on((JSONValue)root).next("version").asString();
        String name = JSONWalk.on((JSONValue)root).next("name").asString();
        return new ProcessDefinitionRef(id, name, version);
    }

    public static List<String> parseRolesAssigned(String json) {
        ArrayList<String> roles = new ArrayList<String>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on((JSONValue)root).next("roles").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            boolean assigned = JSONWalk.on((JSONValue)item).next("assigned").asBool();
            String roleName = JSONWalk.on((JSONValue)item).next("role").asString();
            if (!assigned) continue;
            roles.add(roleName);
        }
        return roles;
    }

    public static List<TaskRef> parseTaskReferenceList(String json) {
        ArrayList<TaskRef> results = new ArrayList<TaskRef>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on((JSONValue)root).next("tasks").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            TaskRef ref = DTOParser.parseTaskReference((JSONObject)item);
            results.add(ref);
        }
        return results;
    }

    public static TaskRef parseTaskReference(JSONObject item) {
        long id = JSONWalk.on((JSONValue)item).next("id").asLong();
        long tokenId = JSONWalk.on((JSONValue)item).next("tokenId").asLong();
        long instanceId = JSONWalk.on((JSONValue)item).next("processInstanceId").asLong();
        long processId = JSONWalk.on((JSONValue)item).next("processId").asLong();
        String name = JSONWalk.on((JSONValue)item).next("name").asString();
        String actor = JSONWalk.on((JSONValue)item).next("actor").asString();
        boolean isBlocking = JSONWalk.on((JSONValue)item).next("isBlocking").asBool();
        boolean isSignalling = JSONWalk.on((JSONValue)item).next("isSignalling").asBool();
        TaskRef ref = new TaskRef(id, tokenId, instanceId, processId, name, actor, isSignalling, isBlocking);
        JSONArray pooledActors = JSONWalk.on((JSONValue)item).next("pooledActors").asArray();
        for (int k = 0; k < pooledActors.size(); ++k) {
            JSONValue jsonValue = pooledActors.get(k);
            JSONString t = jsonValue.isString();
            ref.addPooledActor(t.stringValue());
        }
        if (isSignalling) {
            JSONArray arr = JSONWalk.on((JSONValue)item).next("transitionNames").asArray();
            for (int k = 0; k < arr.size(); ++k) {
                JSONValue jsonValue = arr.get(k);
                if (jsonValue.toString().equals("null")) {
                    ConsoleLog.debug((String)("FIXME JBPM-1828: Null value on transitionNames:" + arr.toString()));
                    continue;
                }
                JSONString t = jsonValue.isString();
                ref.getTransitionNames().add(t.stringValue());
            }
        }
        return ref;
    }

    public static Map<String, String> parseFormMapping(String json) {
        throw new RuntimeException("Not implemented");
    }

    public static FormDef parseFormDef(String json) {
        return DTOParser.parseFormDef((JSONValue)JSONParser.parse((String)json));
    }

    public static FormDef parseFormDef(JSONValue root) {
        String formName = JSONWalk.on((JSONValue)root).next("formName").asString();
        FormDef formDef = new FormDef(formName);
        JSONArray array = JSONWalk.on((JSONValue)root).next("fields").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            String label = JSONWalk.on((JSONValue)item).next("label").asString();
            String varName = JSONWalk.on((JSONValue)item).next("varname").asString();
            boolean required = JSONWalk.on((JSONValue)item).next("required").asBool();
            FieldDef.InputType inputType = FieldDef.InputType.valueOf((String)JSONWalk.on((JSONValue)item).next("inputType").asString());
            String dataType = JSONWalk.on((JSONValue)item).next("dataTypeClass").asString();
            formDef.getFields().add(new FieldDef(label, varName, inputType, dataType, required));
        }
        return formDef;
    }

    public static ProcessInstanceRef parseProcessInstance(JSONObject root) {
        ConsoleLog.debug((String)("parse " + root));
        long id = JSONWalk.on((JSONValue)root).next("instanceId").asLong();
        long parentId = JSONWalk.on((JSONValue)root).next("parentId").asLong();
        Date start = JSONWalk.on((JSONValue)root).next("startDate").asDate();
        JSONWalk.JSONWrapper endDateJSON = JSONWalk.on((JSONValue)root).next("endDate");
        Date end = null;
        if (endDateJSON != null) {
            end = endDateJSON.asDate();
        }
        boolean suspended = JSONWalk.on((JSONValue)root).next("suspended").asBool();
        ProcessInstanceRef processInstance = new ProcessInstanceRef(id, parentId, start, end, suspended);
        JSONObject tokJso = JSONWalk.on((JSONValue)root).next("rootToken").asObject();
        TokenReference rootToken = DTOParser.parseTokenReference((JSONObject)tokJso);
        processInstance.setRootToken(rootToken);
        return processInstance;
    }

    public static TokenReference parseTokenReference(JSONObject jso) {
        JSONString item;
        long rootTokenId = JSONWalk.on((JSONValue)jso).next("id").asLong();
        String name = JSONWalk.on((JSONValue)jso).next("name").asString();
        String nodeName = JSONWalk.on((JSONValue)jso).next("currentNodeName").asString();
        TokenReference rt = new TokenReference(rootTokenId, name, nodeName);
        boolean canBeSignaled = JSONWalk.on((JSONValue)jso).next("canBeSignaled").asBool();
        rt.setCanBeSignaled(canBeSignaled);
        JSONArray signals = JSONWalk.on((JSONValue)jso).next("availableSignals").asArray();
        for (int i = 0; i < signals.size(); ++i) {
            JSONValue jsonValue = signals.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.debug((String)("FIXME JBPM-1828: Null value on availableSignals:" + signals.toString()));
                continue;
            }
            item = jsonValue.isString();
            rt.getAvailableSignals().add(item.stringValue());
        }
        JSONArray childArr = JSONWalk.on((JSONValue)jso).next("children").asArray();
        for (int i = 0; i < childArr.size(); ++i) {
            item = childArr.get(i).isObject();
            rt.getChildren().add(DTOParser.parseTokenReference((JSONObject)item));
        }
        return rt;
    }

    public static List<String> parseStringArray(JSONValue jso) {
        ArrayList<String> result = new ArrayList<String>();
        JSONArray jsonArray = jso.isArray();
        if (null == jsonArray) {
            throw new IllegalArgumentException("Not an array: " + jso);
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONValue jsonValue = jsonArray.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.debug((String)("FIXME JBPM-1828: Null value on string array:" + jsonArray.toString()));
                continue;
            }
            JSONString item = jsonValue.isString();
            result.add(item.stringValue());
        }
        return result;
    }
}

