/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.report;

import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.ScriptTagProxy;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.report.ProcessReportEditor;

public class OverviewReportEditor
extends Editor {
    public static final String ID = "org.jboss.bpm.metric.ProcessMetricOverview";
    private MainView view;

    public OverviewReportEditor(MainView view) {
        this.view = view;
        this.setId(ID);
        this.setPaddings(10);
        this.setLayout((ContainerLayout)new VerticalLayout(10));
        this.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onExamine(String definitionName) {
        String editorId = ProcessReportEditor.createWidgetID((String)definitionName);
        if (this.view.hasEditor(editorId)) {
            this.view.showEditor(editorId);
        } else {
            this.view.addEditor((Editor)new ProcessReportEditor(definitionName, this.view));
        }
    }

    private ComboBox buildProcessSelection() {
        RecordDef recordDef = new RecordDef(new FieldDef[]{new IntegerFieldDef("processId"), new StringFieldDef("name"), new StringFieldDef("version")});
        JsonReader reader = new JsonReader(recordDef);
        reader.setRoot("definitions");
        reader.setTotalProperty("totalCount");
        reader.setId("processId");
        ScriptTagProxy dataProxy = new ScriptTagProxy(this.view.getUrlBuilder().getProcessDefinitionsURL(), 10000);
        Store store = new Store((DataProxy)dataProxy, (Reader)reader, false);
        store.load();
        ComboBox cb = new ComboBox();
        cb.setMinChars(1);
        cb.setFieldLabel("Process definition");
        cb.setStore(store);
        cb.setDisplayField("name");
        cb.setMode(ComboBox.LOCAL);
        cb.setTriggerAction(ComboBox.ALL);
        cb.setEmptyText("Please enter a name");
        cb.setLoadingText("Searching...");
        cb.setTypeAhead(true);
        cb.setSelectOnFocus(true);
        cb.setWidth(180);
        return cb;
    }

    public String getEditorId() {
        return ID;
    }

    public String getTitle() {
        return "Metrics and Stats";
    }

    public String getIconCSS() {
        return "bpm-report-icon";
    }

    static /* synthetic */ ComboBox access$000(OverviewReportEditor x0) {
        return x0.buildProcessSelection();
    }

    static /* synthetic */ void access$100(OverviewReportEditor x0, String x1) {
        x0.onExamine(x1);
    }
}

