/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormPanel;
import java.util.List;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AssignmentCallback;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelChangeListener;
import org.jboss.bpm.console.client.util.ModelListenerRegistry;
import org.jboss.bpm.console.client.widgets.FormWidgets;
import org.jboss.bpm.console.client.widgets.RefreshableComboBox;

class AssignmentFormPanel
extends Panel
implements ModelChangeListener {
    private FormPanel formPanel;
    private MainView mainView;
    private AssignmentCallback callback;
    private List<String> availableActors;
    private TaskRef selectedInstance;

    public AssignmentFormPanel(MainView mainView, AssignmentCallback callback) {
        this.mainView = mainView;
        this.callback = callback;
        this.setTitle("Reassign Task");
        this.setBorder(false);
        this.setFrame(false);
        this.setIconCls("bpm-tools-icon");
        this.formPanel = FormWidgets.createBaseFormPanel();
        RefreshableComboBox cb = new RefreshableComboBox("actorId", "Actor");
        this.formPanel.add((Component)cb);
        Button assignBtn = new Button("Delegate", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.formPanel.add((Component)assignBtn);
        this.add((Component)this.formPanel);
        this.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onModelChange(ModelListenerRegistry parent, Object changeEvent) {
        boolean hasPooledActors;
        this.selectedInstance = (TaskRef)changeEvent;
        this.availableActors = null;
        boolean bl = hasPooledActors = this.selectedInstance.getPooledActors().size() > 0;
        if (hasPooledActors) {
            this.availableActors = this.selectedInstance.getPooledActors();
        } else if (!hasPooledActors && TaskRef.STATE.ASSIGNED == this.selectedInstance.getCurrentState()) {
            this.loadActors();
        } else {
            throw new IllegalStateException(this.selectedInstance + " has no pooled actors and no assignee");
        }
        this.refreshComboBox();
    }

    public void onRecordChange(ModelListenerRegistry parent, Record record) {
    }

    private void loadActors() {
        String url = this.mainView.getUrlBuilder().getAvailableActorsUrl(this.mainView.getUsername());
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, url);
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            ConsoleLog.error((String)"Request failed", (Throwable)e1);
        }
    }

    private void refreshComboBox() {
        if (null == this.availableActors) {
            throw new IllegalArgumentException("available actors cannot be null");
        }
        if (this.isRendered()) {
            Form form = this.formPanel.getForm();
            RefreshableComboBox cb = (RefreshableComboBox)form.findField("actorId");
            cb.display(this.availableActors);
        }
    }

    private void reassignTask(long taskId, String actor) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.mainView.getUrlBuilder().getTaskAssignmentURL(taskId, actor));
        try {
            rb.sendRequest("", (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            ConsoleLog.error((String)"Request failed", (Throwable)e1);
        }
    }

    public void onReset() {
        Form form = this.formPanel.getForm();
        form.reset();
    }

    static /* synthetic */ FormPanel access$000(AssignmentFormPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ TaskRef access$100(AssignmentFormPanel x0) {
        return x0.selectedInstance;
    }

    static /* synthetic */ void access$200(AssignmentFormPanel x0, long x1, String x2) {
        x0.reassignTask(x1, x2);
    }

    static /* synthetic */ void access$300(AssignmentFormPanel x0) {
        x0.refreshComboBox();
    }

    static /* synthetic */ List access$402(AssignmentFormPanel x0, List x1) {
        x0.availableActors = x1;
        return x0.availableActors;
    }

    static /* synthetic */ TaskRef access$102(AssignmentFormPanel x0, TaskRef x1) {
        x0.selectedInstance = x1;
        return x0.selectedInstance;
    }

    static /* synthetic */ AssignmentCallback access$500(AssignmentFormPanel x0) {
        return x0.callback;
    }
}

